/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRevisit;
import org.netpreserve.jwarc.cdx.CdxFormat;
import org.netpreserve.jwarc.cdx.CdxWriter;

public class CdxTool {
    public static void main(String[] args) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        CdxFormat.Builder cdxFormatBuilder = new CdxFormat.Builder();
        boolean printHeader = true;
        boolean fullFilePath = false;
        boolean postAppend = false;
        Predicate<WarcRecord> filter = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                block20 : switch (args[i]) {
                    case "-f": 
                    case "--format": {
                        String format;
                        switch (format = args[++i]) {
                            case "CDX9": {
                                cdxFormatBuilder.legend("N b a m s k r V g");
                                break block20;
                            }
                            case "CDX10": {
                                cdxFormatBuilder.legend("N b a m s k r M V g");
                                break block20;
                            }
                            case "CDX11": {
                                cdxFormatBuilder.legend("N b a m s k r M S V g");
                                break block20;
                            }
                        }
                        cdxFormatBuilder.legend(format);
                        break;
                    }
                    case "-h": 
                    case "--help": {
                        System.out.println("Usage: jwarc cdx [--format LEGEND] warc-files...");
                        System.out.println();
                        System.out.println("  -d, --digest-unchanged   Include records with unchanged digest");
                        System.out.println("  -f, --format LEGEND      CDX format may be CDX9, CDX11 or a custom legend");
                        System.out.println("      --no-header          Don't print the CDX header line");
                        System.out.println("  -p, --post-append        Append the request body to the urlkey field");
                        System.out.println("      --revisits-excluded  Don't index revisit records");
                        System.out.println("  -w, --warc-full-path     Use absolute paths for the filename field");
                        return;
                    }
                    case "--no-header": {
                        printHeader = false;
                        break;
                    }
                    case "-p": 
                    case "--post-append": {
                        postAppend = true;
                        break;
                    }
                    case "-d": 
                    case "--digest-unchanged": {
                        cdxFormatBuilder.digestUnchanged();
                        break;
                    }
                    case "-r": 
                    case "--revisits-included": {
                        filter = null;
                        break;
                    }
                    case "--revisits-excluded": {
                        filter = record -> !(record instanceof WarcRevisit);
                        break;
                    }
                    case "-w": 
                    case "--warc-full-path": {
                        fullFilePath = true;
                        break;
                    }
                    default: {
                        System.err.println("Unrecognized option: " + args[i]);
                        System.err.println("Usage: jwarc cdx [--format LEGEND] warc-files...");
                        System.exit(1);
                        return;
                    }
                }
                continue;
            }
            files.add(Paths.get(args[i], new String[0]));
        }
        CdxWriter cdxWriter = new CdxWriter(new OutputStreamWriter(System.out));
        Object object = null;
        try {
            cdxWriter.onWarning(System.err::println);
            cdxWriter.setFormat(cdxFormatBuilder.build());
            cdxWriter.setPostAppend(postAppend);
            cdxWriter.setRecordFilter(filter);
            if (printHeader) {
                cdxWriter.writeHeaderLine();
            }
            cdxWriter.process(files, fullFilePath);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (cdxWriter != null) {
                if (object != null) {
                    try {
                        cdxWriter.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    cdxWriter.close();
                }
            }
        }
    }
}

