/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.wacz;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import shaded.org.apache.commons.io.input.CloseShieldInputStream;

public class WACZParser
extends AbstractParser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"x-wacz"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        EmbeddedDocumentExtractor embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
        if (stream instanceof TikaInputStream) {
            ZipFile zip = (ZipFile)((TikaInputStream)stream).getOpenContainer();
            if (zip == null && ((TikaInputStream)stream).hasFile()) {
                zip = new ZipFile(((TikaInputStream)stream).getFile());
            }
            if (zip != null) {
                try {
                    this.processZip(zip, xhtml, metadata, embeddedDocumentExtractor);
                }
                finally {
                    zip.close();
                }
            } else {
                this.processStream(stream, xhtml, metadata, embeddedDocumentExtractor);
            }
        } else {
            this.processStream(stream, xhtml, metadata, embeddedDocumentExtractor);
        }
        xhtml.endDocument();
    }

    private void processStream(InputStream stream, XHTMLContentHandler xhtml, Metadata metadata, EmbeddedDocumentExtractor ex) throws SAXException, IOException {
        try (ZipArchiveInputStream zais = new ZipArchiveInputStream(new CloseShieldInputStream(stream));){
            ZipArchiveEntry zae = zais.getNextZipEntry();
            while (zae != null) {
                String name = zae.getName();
                if (name.startsWith("archive/")) {
                    name = name.substring(8);
                    this.processWARC(zais, zae, name, xhtml, metadata, ex);
                } else if ("datapackage.json".equals(name)) {
                    this.processDataPackage(zais, zae, xhtml, metadata);
                }
                zae = zais.getNextZipEntry();
            }
        }
    }

    private void processDataPackage(InputStream is, ZipArchiveEntry zae, XHTMLContentHandler xhtml, Metadata metadata) throws IOException {
    }

    private void processWARC(InputStream zais, ZipArchiveEntry zae, String name, XHTMLContentHandler xhtml, Metadata parentMetadata, EmbeddedDocumentExtractor ex) throws IOException, SAXException {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", name);
        metadata.set("Content-Length", Long.toString(zae.getSize()));
        try (InputStream inputStream = this.getMaybeGzipInputStream((InputStream)TikaInputStream.get((InputStream)zais));){
            if (ex.shouldParseEmbedded(metadata)) {
                ex.parseEmbedded(inputStream, (ContentHandler)xhtml, metadata, true);
            }
        }
    }

    private InputStream getMaybeGzipInputStream(InputStream is) throws IOException {
        is.mark(2);
        byte[] firstTwo = new byte[2];
        try {
            IOUtils.readFully(is, firstTwo);
        }
        finally {
            is.reset();
        }
        int magic = (firstTwo[1] & 0xFF) << 8 | firstTwo[0] & 0xFF;
        if (35615 == magic) {
            return new GzipCompressorInputStream(is);
        }
        return is;
    }

    private void processZip(ZipFile zip, XHTMLContentHandler xhtml, Metadata metadata, EmbeddedDocumentExtractor ex) throws IOException, SAXException {
        Enumeration<ZipArchiveEntry> zaeEnum = zip.getEntries();
        while (zaeEnum.hasMoreElements()) {
            ZipArchiveEntry zae = zaeEnum.nextElement();
            String name = zae.getName();
            if (name.startsWith("archive/")) {
                name = name.substring(8);
                this.processWARC((InputStream)TikaInputStream.get((InputStream)zip.getInputStream(zae)), zae, name, xhtml, metadata, ex);
                continue;
            }
            if (!"datapackage.json".equals(name)) continue;
            this.processDataPackage((InputStream)TikaInputStream.get((InputStream)zip.getInputStream(zae)), zae, xhtml, metadata);
        }
    }
}

