/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetRecognizer;
import shaded.org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;

public class CharsetMatch
implements Comparable<CharsetMatch> {
    private int fConfidence;
    private byte[] fRawInput = null;
    private int fRawLength;
    private InputStream fInputStream = null;
    private String fCharsetName;
    private String fLang;

    CharsetMatch(CharsetDetector det, CharsetRecognizer rec, int conf) {
        this.fConfidence = conf;
        if (det.fInputStream == null) {
            this.fRawInput = det.fRawInput;
            this.fRawLength = det.fRawLength;
        }
        this.fInputStream = det.fInputStream;
        this.fCharsetName = rec.getName();
        this.fLang = rec.getLanguage();
    }

    CharsetMatch(CharsetDetector det, CharsetRecognizer rec, int conf, String csName, String lang) {
        this.fConfidence = conf;
        if (det.fInputStream == null) {
            this.fRawInput = det.fRawInput;
            this.fRawLength = det.fRawLength;
        }
        this.fInputStream = det.fInputStream;
        this.fCharsetName = csName;
        this.fLang = lang;
    }

    public Reader getReader() {
        InputStream inputStream = this.fInputStream;
        if (inputStream == null) {
            inputStream = new UnsynchronizedByteArrayInputStream(this.fRawInput, 0, this.fRawLength);
        }
        try {
            inputStream.reset();
            return new InputStreamReader(inputStream, this.getName());
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getString() throws IOException {
        return this.getString(-1);
    }

    public String getString(int maxLength) throws IOException {
        String result = null;
        if (this.fInputStream != null) {
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[1024];
            Reader reader = this.getReader();
            int max = maxLength < 0 ? Integer.MAX_VALUE : maxLength;
            int bytesRead = 0;
            while ((bytesRead = reader.read(buffer, 0, Math.min(max, 1024))) > 0) {
                sb.append(buffer, 0, bytesRead);
                max -= bytesRead;
            }
            reader.close();
            return sb.toString();
        }
        String name = this.getNormalizedName();
        result = new String(this.fRawInput, name);
        return result;
    }

    public String getNormalizedName() {
        int startSuffix;
        String name = this.getName();
        int n = startSuffix = !name.contains("_rtl") ? name.indexOf("_ltr") : name.indexOf("_rtl");
        if (startSuffix > 0) {
            name = name.substring(0, startSuffix);
        }
        return name;
    }

    public int getConfidence() {
        return this.fConfidence;
    }

    public String getName() {
        return this.fCharsetName;
    }

    public String getLanguage() {
        return this.fLang;
    }

    @Override
    public int compareTo(CharsetMatch other) {
        int compareResult = 0;
        if (this.fConfidence > other.fConfidence) {
            compareResult = 1;
        } else if (this.fConfidence < other.fConfidence) {
            compareResult = -1;
        }
        return compareResult;
    }

    public boolean equals(Object o) {
        if (o instanceof CharsetMatch) {
            CharsetMatch that = (CharsetMatch)o;
            return this.fConfidence == that.fConfidence;
        }
        return false;
    }

    public int hashCode() {
        return this.fConfidence;
    }

    public String toString() {
        String s = "Match of " + this.fCharsetName;
        if (this.getLanguage() != null) {
            s = s + " in " + this.getLanguage();
        }
        s = s + " with confidence " + this.fConfidence;
        return s;
    }
}

