/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dbf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.EndianUtils;
import org.apache.tika.parser.dbf.DBFColumnHeader;
import org.apache.tika.parser.dbf.DBFReader;
import shaded.org.apache.commons.io.IOUtils;

class DBFFileHeader {
    private DBFReader.Version version;
    private Calendar lastModified;
    private int numRecords = -1;
    private short numBytesInHeader;
    private short numBytesInRecord;
    private DBFColumnHeader[] cols;

    DBFFileHeader() {
    }

    public static DBFFileHeader parse(InputStream is) throws IOException, TikaException {
        DBFColumnHeader colHeader;
        DBFFileHeader header = new DBFFileHeader();
        int firstByte = is.read();
        header.version = DBFReader.getVersion(firstByte);
        if (header.version == null) {
            throw new TikaException("Unrecognized first byte in DBFFile: " + firstByte);
        }
        int lastModYear = is.read();
        int lastModMonth = is.read();
        int lastModDay = is.read();
        Calendar now = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        lastModYear = lastModYear + 2000 > now.get(1) ? (lastModYear += 1900) : (lastModYear += 2000);
        GregorianCalendar lastModified = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        lastModified.set(lastModYear, lastModMonth - 1, lastModDay, 0, 0, 0);
        header.lastModified = lastModified;
        header.numRecords = EndianUtils.readIntLE((InputStream)is);
        header.numBytesInHeader = EndianUtils.readShortLE((InputStream)is);
        header.numBytesInRecord = EndianUtils.readShortLE((InputStream)is);
        IOUtils.skipFully(is, 20L);
        int numCols = 0;
        LinkedList<DBFColumnHeader> headers = new LinkedList<DBFColumnHeader>();
        int bytesAccountedFor = 0;
        do {
            colHeader = DBFFileHeader.readCol(is);
            ++numCols;
            headers.add(colHeader);
        } while ((bytesAccountedFor += colHeader.fieldLength) < header.numBytesInRecord - 1);
        header.cols = headers.toArray(new DBFColumnHeader[0]);
        int endOfHeader = is.read();
        if (endOfHeader != 13) {
            throw new TikaException("Expected new line at end of header");
        }
        long totalReadSoFar = 32 + numCols * 32 + 1;
        long extraHeaderBytes = (long)header.numBytesInHeader - totalReadSoFar;
        IOUtils.skipFully(is, extraHeaderBytes);
        return header;
    }

    private static DBFColumnHeader readCol(InputStream is) throws IOException, TikaException {
        byte[] fieldRecord = new byte[32];
        IOUtils.readFully(is, fieldRecord);
        DBFColumnHeader col = new DBFColumnHeader();
        col.name = new byte[11];
        System.arraycopy(fieldRecord, 0, col.name, 0, 10);
        int colType = fieldRecord[11] & 0xFF;
        if (colType < 0) {
            throw new IOException("File truncated before coltype in header");
        }
        col.setType(colType);
        col.fieldLength = fieldRecord[16] & 0xFF;
        if (col.fieldLength < 0) {
            throw new TikaException("Field length for column " + col.getName(StandardCharsets.US_ASCII) + " is < 0");
        }
        if (col.fieldLength > 66000) {
            throw new TikaException("Field length (" + col.fieldLength + ") is greater than DBReader.MAX_FIELD_LENGTH (" + 66000 + ")");
        }
        col.decimalCount = fieldRecord[17] & 0xFF;
        return col;
    }

    DBFColumnHeader[] getCols() {
        return this.cols;
    }

    int getNumRecords() {
        return this.numRecords;
    }

    Calendar getLastModified() {
        return this.lastModified;
    }

    DBFReader.Version getVersion() {
        return this.version;
    }

    public String toString() {
        return "DBFFileHeader{lastModified=" + this.lastModified + ", numRecords=" + this.numRecords + ", numBytesInHeader=" + this.numBytesInHeader + ", numBytesInRecord=" + this.numBytesInRecord + ", cols=" + Arrays.toString(this.cols) + '}';
    }
}

