/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.tools.AngleCollector;
import org.apache.pdfbox.tools.FilteredTextStripper;
import org.apache.pdfbox.tools.NullWriter;
import org.apache.pdfbox.tools.PDFText2HTML;
import org.apache.pdfbox.util.Matrix;

public final class ExtractText {
    private static final Log LOG = LogFactory.getLog(ExtractText.class);
    private static final String PASSWORD = "-password";
    private static final String ENCODING = "-encoding";
    private static final String CONSOLE = "-console";
    private static final String START_PAGE = "-startPage";
    private static final String END_PAGE = "-endPage";
    private static final String SORT = "-sort";
    private static final String IGNORE_BEADS = "-ignoreBeads";
    private static final String DEBUG = "-debug";
    private static final String HTML = "-html";
    private static final String ALWAYSNEXT = "-alwaysNext";
    private static final String ROTATION_MAGIC = "-rotationMagic";
    private static final String STD_ENCODING = "UTF-8";
    private boolean debugOutput = false;

    private ExtractText() {
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        ExtractText extractor = new ExtractText();
        extractor.startExtraction(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startExtraction(String[] args) throws IOException {
        boolean toConsole = false;
        boolean toHTML = false;
        boolean sort = false;
        boolean separateBeads = true;
        boolean alwaysNext = false;
        boolean rotationMagic = false;
        String password = "";
        String encoding = STD_ENCODING;
        String pdfFile = null;
        String outputFile = null;
        String ext = ".txt";
        int startPage = 1;
        int endPage = Integer.MAX_VALUE;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(ENCODING)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                encoding = args[i];
                continue;
            }
            if (args[i].equals(START_PAGE)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                startPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(HTML)) {
                toHTML = true;
                ext = ".html";
                continue;
            }
            if (args[i].equals(SORT)) {
                sort = true;
                continue;
            }
            if (args[i].equals(IGNORE_BEADS)) {
                separateBeads = false;
                continue;
            }
            if (args[i].equals(ALWAYSNEXT)) {
                alwaysNext = true;
                continue;
            }
            if (args[i].equals(ROTATION_MAGIC)) {
                rotationMagic = true;
                continue;
            }
            if (args[i].equals(DEBUG)) {
                this.debugOutput = true;
                continue;
            }
            if (args[i].equals(END_PAGE)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                endPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(CONSOLE)) {
                toConsole = true;
                continue;
            }
            if (pdfFile == null) {
                pdfFile = args[i];
                continue;
            }
            outputFile = args[i];
        }
        if (pdfFile == null) {
            ExtractText.usage();
            return;
        }
        OutputStreamWriter output = null;
        PDDocument document = null;
        try {
            Map embeddedFileNames;
            PDEmbeddedFilesNameTreeNode embeddedFiles;
            PDFTextStripper stripper;
            AccessPermission ap;
            long startTime = this.startProcessing("Loading PDF " + pdfFile);
            if (outputFile == null && pdfFile.length() > 4) {
                outputFile = new File(pdfFile.substring(0, pdfFile.length() - 4) + ext).getAbsolutePath();
            }
            if (!(ap = (document = PDDocument.load(new File(pdfFile), password)).getCurrentAccessPermission()).canExtractContent()) {
                throw new IOException("You do not have permission to extract text");
            }
            this.stopProcessing("Time for loading: ", startTime);
            if (toConsole) {
                output = new OutputStreamWriter((OutputStream)System.out, encoding);
            } else {
                if (toHTML && !STD_ENCODING.equals(encoding)) {
                    encoding = STD_ENCODING;
                    System.out.println("The encoding parameter is ignored when writing html output.");
                }
                output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
            }
            startTime = this.startProcessing("Starting text extraction");
            if (this.debugOutput) {
                System.err.println("Writing to " + outputFile);
            }
            if (toHTML) {
                stripper = new PDFText2HTML();
                stripper.setSortByPosition(sort);
                stripper.setShouldSeparateByBeads(separateBeads);
                stripper.setStartPage(startPage);
                stripper.setEndPage(endPage);
                stripper.writeText(document, output);
            } else {
                stripper = rotationMagic ? new FilteredTextStripper() : new PDFTextStripper();
                stripper.setSortByPosition(sort);
                stripper.setShouldSeparateByBeads(separateBeads);
                this.extractPages(startPage, Math.min(endPage, document.getNumberOfPages()), stripper, document, output, rotationMagic, alwaysNext);
            }
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            PDDocumentNameDictionary names = catalog.getNames();
            if (names != null && (embeddedFiles = names.getEmbeddedFiles()) != null && (embeddedFileNames = embeddedFiles.getNames()) != null) {
                for (Map.Entry ent : embeddedFileNames.entrySet()) {
                    PDComplexFileSpecification spec;
                    PDEmbeddedFile file;
                    if (this.debugOutput) {
                        System.err.println("Processing embedded file " + ent.getKey() + ":");
                    }
                    if ((file = (spec = (PDComplexFileSpecification)ent.getValue()).getEmbeddedFile()) == null || !"application/pdf".equals(file.getSubtype())) continue;
                    if (this.debugOutput) {
                        System.err.println("  is PDF (size=" + file.getSize() + ")");
                    }
                    COSInputStream fis = file.createInputStream();
                    PDDocument subDoc = null;
                    try {
                        subDoc = PDDocument.load(fis);
                        if (toHTML) {
                            stripper.writeText(subDoc, output);
                            continue;
                        }
                        this.extractPages(1, subDoc.getNumberOfPages(), stripper, subDoc, output, rotationMagic, alwaysNext);
                    }
                    finally {
                        ((InputStream)fis).close();
                        IOUtils.closeQuietly(subDoc);
                    }
                }
            }
            this.stopProcessing("Time for extraction: ", startTime);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            IOUtils.closeQuietly(document);
            throw throwable;
        }
        IOUtils.closeQuietly(output);
        IOUtils.closeQuietly(document);
    }

    private void extractPages(int startPage, int endPage, PDFTextStripper stripper, PDDocument document, Writer output, boolean rotationMagic, boolean alwaysNext) throws IOException {
        for (int p = startPage; p <= endPage; ++p) {
            stripper.setStartPage(p);
            stripper.setEndPage(p);
            try {
                if (rotationMagic) {
                    PDPage page = document.getPage(p - 1);
                    int rotation = page.getRotation();
                    page.setRotation(0);
                    AngleCollector angleCollector = new AngleCollector();
                    angleCollector.setStartPage(p);
                    angleCollector.setEndPage(p);
                    angleCollector.writeText(document, new NullWriter());
                    for (int angle : angleCollector.getAngles()) {
                        PDPageContentStream cs = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.PREPEND, false);
                        cs.transform(Matrix.getRotateInstance(-Math.toRadians(angle), 0.0f, 0.0f));
                        cs.close();
                        stripper.writeText(document, output);
                        ((COSArray)page.getCOSObject().getItem(COSName.CONTENTS)).remove(0);
                    }
                    page.setRotation(rotation);
                    continue;
                }
                stripper.writeText(document, output);
                continue;
            }
            catch (IOException ex) {
                if (!alwaysNext) {
                    throw ex;
                }
                LOG.error("Failed to process page " + p, ex);
            }
        }
    }

    private long startProcessing(String message) {
        if (this.debugOutput) {
            System.err.println(message);
        }
        return System.currentTimeMillis();
    }

    private void stopProcessing(String message, long startTime) {
        if (this.debugOutput) {
            long stopTime = System.currentTimeMillis();
            float elapsedTime = (float)(stopTime - startTime) / 1000.0f;
            System.err.println(message + elapsedTime + " seconds");
        }
    }

    static int getAngle(TextPosition text) {
        Matrix m = text.getTextMatrix().clone();
        m.concatenate(text.getFont().getFontMatrix());
        return (int)Math.round(Math.toDegrees(Math.atan2(m.getShearY(), m.getScaleY())));
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar ExtractText [options] <inputfile> [output-text-file]\n\nOptions:\n  -password <password>        : Password to decrypt document\n  -encoding <output encoding> : UTF-8 (default) or ISO-8859-1, UTF-16BE,\n                                UTF-16LE, etc.\n  -console                    : Send text to console instead of file\n  -html                       : Output in HTML format instead of raw text\n  -sort                       : Sort the text before writing\n  -ignoreBeads                : Disables the separation by beads\n  -debug                      : Enables debug output about the time consumption\n                                of every stage\n  -alwaysNext                 : Process next page (if applicable) despite\n                                IOException (ignored when -html)\n  -rotationMagic              : Analyze each page for rotated/skewed text,\n                                rotate to 0\u00b0 and extract separately\n                                (slower, and ignored when -html)\n  -startPage <number>         : The first page to start extraction (1 based)\n  -endPage <number>           : The last page to extract (1 based, inclusive)\n  <inputfile>                 : The PDF document to use\n  [output-text-file]          : The file to write the text to";
        System.err.println(message);
        System.exit(1);
    }
}

