/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v121.storage.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum SharedStorageAccessType {
    DOCUMENTADDMODULE("documentAddModule"),
    DOCUMENTSELECTURL("documentSelectURL"),
    DOCUMENTRUN("documentRun"),
    DOCUMENTSET("documentSet"),
    DOCUMENTAPPEND("documentAppend"),
    DOCUMENTDELETE("documentDelete"),
    DOCUMENTCLEAR("documentClear"),
    WORKLETSET("workletSet"),
    WORKLETAPPEND("workletAppend"),
    WORKLETDELETE("workletDelete"),
    WORKLETCLEAR("workletClear"),
    WORKLETGET("workletGet"),
    WORKLETKEYS("workletKeys"),
    WORKLETENTRIES("workletEntries"),
    WORKLETLENGTH("workletLength"),
    WORKLETREMAININGBUDGET("workletRemainingBudget");

    private String value;

    private SharedStorageAccessType(String value) {
        this.value = value;
    }

    public static SharedStorageAccessType fromString(String s) {
        return Arrays.stream(SharedStorageAccessType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SharedStorageAccessType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static SharedStorageAccessType fromJson(JsonInput input) {
        return SharedStorageAccessType.fromString(input.nextString());
    }
}

