/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec;

import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene80.Lucene80DocValuesFormat;
import org.apache.lucene.codecs.lucene87.Lucene87Codec;
import org.opensearch.index.mapper.CompletionFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;

public class PerFieldMappingPostingFormatCodec
extends Lucene87Codec {
    private final Logger logger;
    private final MapperService mapperService;
    private final DocValuesFormat dvFormat = new Lucene80DocValuesFormat(Lucene80DocValuesFormat.Mode.BEST_COMPRESSION);
    static final /* synthetic */ boolean $assertionsDisabled;

    public PerFieldMappingPostingFormatCodec(Lucene87Codec.Mode compressionMode, MapperService mapperService, Logger logger) {
        super(compressionMode);
        this.mapperService = mapperService;
        this.logger = logger;
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        MappedFieldType fieldType = this.mapperService.fieldType(field);
        if (fieldType == null) {
            this.logger.warn("no index mapper found for field: [{}] returning default postings format", (Object)field);
        } else if (fieldType instanceof CompletionFieldMapper.CompletionFieldType) {
            return CompletionFieldMapper.CompletionFieldType.postingsFormat();
        }
        return super.getPostingsFormatForField(field);
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.dvFormat;
    }

    static {
        boolean bl = $assertionsDisabled = !PerFieldMappingPostingFormatCodec.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Codec.forName((String)"Lucene87").getClass().isAssignableFrom(PerFieldMappingPostingFormatCodec.class)) {
            throw new AssertionError((Object)"PerFieldMappingPostingFormatCodec must subclass the latest lucene codec: Lucene87");
        }
    }
}

