/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciithemes;

import de.vandermeer.asciithemes.IsTextArt;
import de.vandermeer.asciithemes.TA_Border;
import de.vandermeer.asciithemes.TA_Corner;
import de.vandermeer.asciithemes.TA_FrameOptions;
import de.vandermeer.asciithemes.TA_Line;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public interface TA_Frame
extends IsTextArt {
    default public String addFrameString(Collection<StrBuilder> coll, int mode) {
        return new StrBuilder().appendWithSeparators(this.addFrame(coll, mode), "\n").toString();
    }

    default public ArrayList<StrBuilder> addFrame(Collection<StrBuilder> coll, int mode) {
        StrBuilder bottom;
        StrBuilder top;
        Validate.notNull(coll);
        Validate.noNullElements(coll);
        int width = 0;
        for (StrBuilder sb : coll) {
            width = sb.length();
        }
        ArrayList<StrBuilder> ret = new ArrayList<StrBuilder>();
        if (TA_FrameOptions.someTopCharacters(mode) && (top = this.renderTopLine(mode, width)).length() > 0) {
            ret.add(top);
        }
        for (StrBuilder sb : coll) {
            if (TA_FrameOptions.borderLeft(mode)) {
                sb.insert(0, (Object)this.getBorder().getBorder(1));
            } else if (TA_FrameOptions.borderLeftNeeded(mode)) {
                sb.insert(0, (Object)new StrBuilder().appendPadding(this.getBorder().getBorder(1).length(), ' '));
            }
            if (TA_FrameOptions.borderRight(mode)) {
                sb.append(this.getBorder().getBorder(2));
            } else if (TA_FrameOptions.borderRightNeeded(mode)) {
                sb.appendPadding(this.getBorder().getBorder(2).length(), ' ');
            }
            ret.add(sb);
        }
        if (TA_FrameOptions.someBottomCharacters(mode) && (bottom = this.renderBottomLine(mode, width)).length() > 0) {
            ret.add(bottom);
        }
        return ret;
    }

    default public StrBuilder renderTopLine(int mode, int width) {
        StrBuilder ret = new StrBuilder(width);
        if (TA_FrameOptions.cornerTopLeft(mode)) {
            ret.append(this.getCorner().getCorner(1));
        } else if (TA_FrameOptions.cornerTopLeftNeeded(mode)) {
            ret.appendPadding(this.getCorner().getCorner(1).length(), ' ');
        }
        if (TA_FrameOptions.lineTop(mode)) {
            ret.append(this.getTopline().getLine(width));
        } else if (TA_FrameOptions.lineTopNeeded(mode)) {
            ret.appendPadding(this.getTopline().getLine(width).length(), ' ');
        }
        if (TA_FrameOptions.cornerTopRight(mode)) {
            ret.append(this.getCorner().getCorner(2));
        } else if (TA_FrameOptions.cornerTopRightNeeded(mode)) {
            ret.appendPadding(this.getCorner().getCorner(2).length(), ' ');
        }
        return ret;
    }

    default public StrBuilder renderBottomLine(int mode, int width) {
        StrBuilder ret = new StrBuilder(width);
        if (TA_FrameOptions.cornerBottomLeft(mode)) {
            ret.append(this.getCorner().getCorner(3));
        } else if (TA_FrameOptions.cornerBottomLeftNeeded(mode)) {
            ret.appendPadding(this.getCorner().getCorner(3).length(), ' ');
        }
        if (TA_FrameOptions.lineBottom(mode)) {
            ret.append(this.getBottomline().getLine(width));
        } else if (TA_FrameOptions.lineBottomNeeded(mode)) {
            ret.appendPadding(width, ' ');
        }
        if (TA_FrameOptions.cornerBottomRight(mode)) {
            ret.append(this.getCorner().getCorner(4));
        } else if (TA_FrameOptions.cornerBottomRightNeeded(mode)) {
            ret.appendPadding(this.getCorner().getCorner(4).length(), ' ');
        }
        return ret;
    }

    public TA_Border getBorder();

    public TA_Line getBottomline();

    public TA_Corner getCorner();

    public TA_Line getTopline();

    default public StrBuilder toDoc() {
        ArrayList<StrBuilder> doc = new ArrayList<StrBuilder>();
        doc.add(new StrBuilder(18).append("Lorem ipsum dolor"));
        doc.add(new StrBuilder(18).append("Lorem ipsum dolor"));
        return new StrBuilder().appendWithSeparators(this.addFrame(doc, 255), "\n");
    }

    public static TA_Frame create(final TA_Line line, final TA_Corner corner, final TA_Border border, final String description) {
        Validate.notNull((Object)line);
        Validate.notNull((Object)corner);
        Validate.notNull((Object)border);
        Validate.notBlank((CharSequence)description);
        return new TA_Frame(){

            @Override
            public TA_Border getBorder() {
                return border;
            }

            @Override
            public TA_Line getBottomline() {
                return line;
            }

            public String getDescription() {
                return description;
            }

            @Override
            public TA_Corner getCorner() {
                return corner;
            }

            @Override
            public TA_Line getTopline() {
                return line;
            }
        };
    }

    public static TA_Frame create(final TA_Line topline, final TA_Line bottomline, final TA_Corner corner, final TA_Border border, final String description) {
        Validate.notNull((Object)topline);
        Validate.notNull((Object)bottomline);
        Validate.notNull((Object)corner);
        Validate.notNull((Object)border);
        Validate.notBlank((CharSequence)description);
        return new TA_Frame(){

            @Override
            public TA_Border getBorder() {
                return border;
            }

            @Override
            public TA_Line getBottomline() {
                return bottomline;
            }

            public String getDescription() {
                return description;
            }

            @Override
            public TA_Corner getCorner() {
                return corner;
            }

            @Override
            public TA_Line getTopline() {
                return topline;
            }
        };
    }
}

