/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.decorators.Decorated;
import org.openqa.selenium.support.decorators.WebDriverDecorator;
import org.openqa.selenium.support.events.WebDriverListener;

@Beta
public class EventFiringDecorator<T extends WebDriver>
extends WebDriverDecorator<T> {
    private static final Logger LOG = Logger.getLogger(EventFiringDecorator.class.getName());
    private final List<WebDriverListener> listeners;

    public EventFiringDecorator(WebDriverListener ... listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    public EventFiringDecorator(Class<T> targetClass, WebDriverListener ... listeners) {
        super(targetClass);
        this.listeners = Arrays.asList(listeners);
    }

    public void beforeCall(Decorated<?> target, Method method, Object[] args) {
        this.listeners.forEach(listener -> this.fireBeforeEvents((WebDriverListener)listener, target, method, args));
        super.beforeCall(target, method, args);
    }

    public void afterCall(Decorated<?> target, Method method, Object[] args, Object result) {
        super.afterCall(target, method, args, result);
        this.listeners.forEach(listener -> this.fireAfterEvents((WebDriverListener)listener, target, method, result, args));
    }

    public Object onError(Decorated<?> target, Method method, Object[] args, InvocationTargetException e) throws Throwable {
        this.listeners.forEach(listener -> {
            try {
                listener.onError(target.getOriginal(), method, args, e);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, t.getMessage(), t);
            }
        });
        return super.onError(target, method, args, e);
    }

    private void fireBeforeEvents(WebDriverListener listener, Decorated<?> target, Method method, Object[] args) {
        try {
            listener.beforeAnyCall(target.getOriginal(), method, args);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, t.getMessage(), t);
        }
        try {
            if (target.getOriginal() instanceof WebDriver) {
                listener.beforeAnyWebDriverCall((WebDriver)target.getOriginal(), method, args);
            } else if (target.getOriginal() instanceof WebElement) {
                listener.beforeAnyWebElementCall((WebElement)target.getOriginal(), method, args);
            } else if (target.getOriginal() instanceof WebDriver.Navigation) {
                listener.beforeAnyNavigationCall((WebDriver.Navigation)target.getOriginal(), method, args);
            } else if (target.getOriginal() instanceof Alert) {
                listener.beforeAnyAlertCall((Alert)target.getOriginal(), method, args);
            } else if (target.getOriginal() instanceof WebDriver.Options) {
                listener.beforeAnyOptionsCall((WebDriver.Options)target.getOriginal(), method, args);
            } else if (target.getOriginal() instanceof WebDriver.Timeouts) {
                listener.beforeAnyTimeoutsCall((WebDriver.Timeouts)target.getOriginal(), method, args);
            } else if (target.getOriginal() instanceof WebDriver.TargetLocator) {
                listener.beforeAnyTargetLocatorCall((WebDriver.TargetLocator)target.getOriginal(), method, args);
            } else if (target.getOriginal() instanceof WebDriver.Window) {
                listener.beforeAnyWindowCall((WebDriver.Window)target.getOriginal(), method, args);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, t.getMessage(), t);
        }
        String methodName = this.createEventMethodName("before", method.getName());
        int argsLength = args != null ? args.length : 0;
        Object[] args2 = new Object[argsLength + 1];
        args2[0] = target.getOriginal();
        for (int i = 0; i < argsLength; ++i) {
            args2[i + 1] = args[i];
        }
        Method m = this.findMatchingMethod(listener, methodName, args2);
        if (m != null) {
            this.callListenerMethod(m, listener, args2);
        }
    }

    private void fireAfterEvents(WebDriverListener listener, Decorated<?> target, Method method, Object res, Object[] args) {
        Method m;
        String methodName = this.createEventMethodName("after", method.getName());
        boolean isVoid = method.getReturnType() == Void.TYPE || method.getReturnType() == WebDriver.Timeouts.class;
        int argsLength = args != null ? args.length : 0;
        Object[] args2 = new Object[argsLength + 1 + (isVoid ? 0 : 1)];
        args2[0] = target.getOriginal();
        for (int i = 0; i < argsLength; ++i) {
            args2[i + 1] = args[i];
        }
        if (!isVoid) {
            args2[args2.length - 1] = res;
        }
        if ((m = this.findMatchingMethod(listener, methodName, args2)) != null) {
            this.callListenerMethod(m, listener, args2);
        }
        try {
            if (target.getOriginal() instanceof WebDriver) {
                listener.afterAnyWebDriverCall((WebDriver)target.getOriginal(), method, args, res);
            } else if (target.getOriginal() instanceof WebElement) {
                listener.afterAnyWebElementCall((WebElement)target.getOriginal(), method, args, res);
            } else if (target.getOriginal() instanceof WebDriver.Navigation) {
                listener.afterAnyNavigationCall((WebDriver.Navigation)target.getOriginal(), method, args, res);
            } else if (target.getOriginal() instanceof Alert) {
                listener.afterAnyAlertCall((Alert)target.getOriginal(), method, args, res);
            } else if (target.getOriginal() instanceof WebDriver.Options) {
                listener.afterAnyOptionsCall((WebDriver.Options)target.getOriginal(), method, args, res);
            } else if (target.getOriginal() instanceof WebDriver.Timeouts) {
                listener.afterAnyTimeoutsCall((WebDriver.Timeouts)target.getOriginal(), method, args, res);
            } else if (target.getOriginal() instanceof WebDriver.TargetLocator) {
                listener.afterAnyTargetLocatorCall((WebDriver.TargetLocator)target.getOriginal(), method, args, res);
            } else if (target.getOriginal() instanceof WebDriver.Window) {
                listener.afterAnyWindowCall((WebDriver.Window)target.getOriginal(), method, args, res);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, t.getMessage(), t);
        }
        try {
            listener.afterAnyCall(target.getOriginal(), method, args, res);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, t.getMessage(), t);
        }
    }

    private String createEventMethodName(String prefix, String originalMethodName) {
        return prefix + originalMethodName.substring(0, 1).toUpperCase() + originalMethodName.substring(1);
    }

    private Method findMatchingMethod(WebDriverListener listener, String methodName, Object[] args) {
        for (Method m : listener.getClass().getMethods()) {
            if (!m.getName().equals(methodName) || !this.parametersMatch(m, args)) continue;
            return m;
        }
        return null;
    }

    private boolean parametersMatch(Method m, Object[] args) {
        Class<?>[] params = m.getParameterTypes();
        if (params.length != args.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            Class<Object> param = params[i];
            if (param.isPrimitive()) {
                if (Boolean.TYPE.equals(param)) {
                    param = Boolean.class;
                } else if (Byte.TYPE.equals(param)) {
                    param = Byte.class;
                } else if (Character.TYPE.equals(param)) {
                    param = Character.class;
                } else if (Double.TYPE.equals(param)) {
                    param = Double.class;
                } else if (Float.TYPE.equals(param)) {
                    param = Float.class;
                } else if (Integer.TYPE.equals(param)) {
                    param = Integer.class;
                } else if (Long.TYPE.equals(param)) {
                    param = Long.class;
                } else if (Short.TYPE.equals(param)) {
                    param = Short.class;
                } else if (Void.TYPE.equals(param)) {
                    param = Void.class;
                }
            }
            if (args[i] == null || param.isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private void callListenerMethod(Method m, WebDriverListener listener, Object[] args) {
        try {
            m.invoke((Object)listener, args);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, t.getMessage(), t);
        }
    }
}

