/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.Calendar;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.RegexFTPFileEntryParserImpl;

public class NTFTPEntryParser
extends RegexFTPFileEntryParserImpl {
    private static final String REGEX = "((?:0[1-9])|(?:1[0-2]))-((?:0[1-9])|(?:[1-2]\\d)|(?:3[0-1]))-(\\d\\d)\\s*((?:0[1-9])|(?:1[012])):([0-5]\\d)\\s*([AP])M\\s*(<DIR>)?\\s*([0-9]+)?\\s+(\\S.*)";

    public NTFTPEntryParser() {
        super(REGEX);
    }

    public FTPFile parseFTPEntry(String entry) {
        FTPFile f = new FTPFile();
        f.setRawListing(entry);
        if (this.matches(entry)) {
            String mo = this.group(1);
            String da = this.group(2);
            String yr = this.group(3);
            String hr = this.group(4);
            String min = this.group(5);
            String ampm = this.group(6);
            String dirString = this.group(7);
            String size = this.group(8);
            String name = this.group(9);
            if (null == name || name.equals(".") || name.equals("..")) {
                return null;
            }
            f.setName(name);
            int month = new Integer(mo) - 1;
            int day = new Integer(da);
            int year = new Integer(yr) + 2000;
            int hour = new Integer(hr);
            int minutes = new Integer(min);
            if (year > 2080) {
                year -= 100;
            }
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.set(1, year);
            cal.set(5, day);
            cal.set(2, month);
            boolean ap = false;
            if ("P".equals(ampm)) {
                ap = true;
                if (hour != 12) {
                    hour += 12;
                }
            } else if (hour == 12) {
                hour = 0;
            }
            cal.set(13, 0);
            cal.set(12, minutes);
            cal.set(11, hour);
            cal.getTime().getTime();
            f.setTimestamp(cal);
            if ("<DIR>".equals(dirString)) {
                f.setType(1);
                f.setSize(0L);
            } else {
                f.setType(0);
                if (null != size) {
                    f.setSize(new Integer(size).intValue());
                }
            }
            return f;
        }
        return null;
    }
}

