/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.config.MapConfig;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;

public class JsonConfig
implements Config {
    private static final Json JSON = new Json();
    private final Config delegate;

    JsonConfig(Reader reader) {
        try {
            this.delegate = new MapConfig((Map)JSON.toType((Reader)Require.nonNull((String)"JSON source", (Object)reader), Json.MAP_TYPE));
        }
        catch (JsonException e) {
            throw new ConfigException("Unable to parse input", new Object[]{e});
        }
    }

    public static Config from(Path path) {
        JsonConfig jsonConfig;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                jsonConfig = new JsonConfig(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigException("Unable to read JSON.", new Object[]{e});
                }
            }
            ((Reader)reader).close();
        }
        return jsonConfig;
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        return this.delegate.getAll(section, option);
    }

    @Override
    public Set<String> getSectionNames() {
        return this.delegate.getSectionNames();
    }

    @Override
    public Set<String> getOptions(String section) {
        return this.delegate.getOptions((String)Require.nonNull((String)"Section name to get options for", (Object)section));
    }
}

