/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.api;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.retries.api.internal.backoff.ExponentialDelayWithHalfJitter;
import software.amazon.awssdk.retries.api.internal.backoff.ExponentialDelayWithJitter;
import software.amazon.awssdk.retries.api.internal.backoff.ExponentialDelayWithoutJitter;
import software.amazon.awssdk.retries.api.internal.backoff.FixedDelayWithJitter;
import software.amazon.awssdk.retries.api.internal.backoff.FixedDelayWithoutJitter;
import software.amazon.awssdk.retries.api.internal.backoff.Immediately;

@SdkPublicApi
@ThreadSafe
public interface BackoffStrategy {
    public Duration computeDelay(int var1);

    public static BackoffStrategy retryImmediately() {
        return new Immediately();
    }

    public static BackoffStrategy fixedDelay(Duration delay) {
        return new FixedDelayWithJitter(ThreadLocalRandom::current, delay);
    }

    public static BackoffStrategy fixedDelayWithoutJitter(Duration delay) {
        return new FixedDelayWithoutJitter(delay);
    }

    public static BackoffStrategy exponentialDelay(Duration baseDelay, Duration maxDelay) {
        return new ExponentialDelayWithJitter(ThreadLocalRandom::current, baseDelay, maxDelay);
    }

    public static BackoffStrategy exponentialDelayHalfJitter(Duration baseDelay, Duration maxDelay) {
        return new ExponentialDelayWithHalfJitter(ThreadLocalRandom::current, baseDelay, maxDelay);
    }

    public static BackoffStrategy exponentialDelayWithoutJitter(Duration baseDelay, Duration maxDelay) {
        return new ExponentialDelayWithoutJitter(baseDelay, maxDelay);
    }
}

