/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.registry;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;

public class CreateRegistryClient
extends AbstractNiFiCommand<StringResult> {
    public static final String DEFAULT_REGISTRY_CLIENT_TYPE = "org.apache.nifi.registry.flow.NifiRegistryFlowRegistryClient";

    public CreateRegistryClient() {
        super("create-reg-client", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a registry client using the provided information.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.REGISTRY_CLIENT_NAME.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_URL.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_DESC.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String name = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_NAME);
        String url = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_URL);
        String desc = this.getArg(properties, CommandOption.REGISTRY_CLIENT_DESC);
        String type = this.getArg(properties, CommandOption.REGISTRY_CLIENT_TYPE);
        if (type == null) {
            type = DEFAULT_REGISTRY_CLIENT_TYPE;
        }
        FlowRegistryClientDTO flowRegistryClientDTO = new FlowRegistryClientDTO();
        flowRegistryClientDTO.setName(name);
        flowRegistryClientDTO.setProperties(Map.of("url", url));
        flowRegistryClientDTO.setDescription(desc);
        flowRegistryClientDTO.setType(type);
        FlowRegistryClientEntity clientEntity = new FlowRegistryClientEntity();
        clientEntity.setComponent(flowRegistryClientDTO);
        clientEntity.setRevision(this.getInitialRevisionDTO());
        FlowRegistryClientEntity createdEntity = client.getControllerClient().createRegistryClient(clientEntity);
        return new StringResult(createdEntity.getId(), this.getContext().isInteractive());
    }
}

