/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.security.krb.AbstractKerberosUser;
import org.apache.nifi.security.krb.PasswordConfiguration;
import org.apache.nifi.security.krb.UsernamePasswordCallbackHandler;

public class KerberosPasswordUser
extends AbstractKerberosUser {
    private final String password;

    public KerberosPasswordUser(String principal, String password) {
        super(principal);
        this.password = (String)Validate.notBlank((CharSequence)password);
    }

    @Override
    protected Configuration createConfiguration() {
        return new PasswordConfiguration();
    }

    @Override
    protected CallbackHandler createCallbackHandler() {
        return new UsernamePasswordCallbackHandler(this.principal, this.password);
    }
}

