/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.union.AbstractSetRecordCursor;
import io.questdb.std.Misc;

class ExceptRecordCursor
extends AbstractSetRecordCursor {
    private final Map map;
    private final RecordSink recordSink;
    private boolean isOpen;
    private Record recordA;
    private Record recordB;

    public ExceptRecordCursor(Map map, RecordSink recordSink) {
        this.map = map;
        this.recordSink = recordSink;
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.map.close();
            super.close();
        }
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordB() {
        return this.cursorA.getRecordB();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.cursorA.getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        while (this.cursorA.hasNext()) {
            MapKey key = this.map.withKey();
            key.put(this.recordA, this.recordSink);
            if (key.notFound()) {
                return true;
            }
            this.circuitBreaker.statefulThrowExceptionIfTripped();
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.cursorA.newSymbolTable(columnIndex);
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.cursorA.recordAt(record, atRowId);
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toTop() {
        this.cursorA.toTop();
    }

    private void hashCursorB() {
        while (this.cursorB.hasNext()) {
            MapKey key = this.map.withKey();
            key.put(this.recordB, this.recordSink);
            key.createValue();
            this.circuitBreaker.statefulThrowExceptionIfTripped();
        }
        this.cursorB = Misc.free(this.cursorB);
    }

    @Override
    void of(RecordCursor cursorA, RecordCursor cursorB, SqlExecutionCircuitBreaker circuitBreaker) throws SqlException {
        super.of(cursorA, cursorB, circuitBreaker);
        this.recordB = cursorB.getRecord();
        if (!this.isOpen) {
            this.map.reopen();
            this.isOpen = true;
        }
        this.hashCursorB();
        this.recordA = cursorA.getRecord();
        this.toTop();
    }
}

