/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import com.azure.core.exception.ResourceNotFoundException;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import java.util.Objects;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;

public class AzureKeyVaultSecretSensitivePropertyProvider
implements SensitivePropertyProvider {
    private static final String FORWARD_SLASH = "/";
    private static final String PERIOD = "\\.";
    private static final String DASH = "-";
    private static final String IDENTIFIER_KEY = "azure/keyvault/secret";
    private SecretClient secretClient;

    AzureKeyVaultSecretSensitivePropertyProvider(SecretClient secretClient) {
        this.secretClient = secretClient;
    }

    public String getIdentifierKey() {
        return IDENTIFIER_KEY;
    }

    public boolean isSupported() {
        return this.secretClient != null;
    }

    public String protect(String unprotectedValue, ProtectedPropertyContext context) throws SensitivePropertyProtectionException {
        Objects.requireNonNull(unprotectedValue, "Value required");
        String secretName = this.getSecretName(context);
        try {
            KeyVaultSecret keyVaultSecret = this.secretClient.setSecret(secretName, unprotectedValue);
            return keyVaultSecret.getId();
        }
        catch (RuntimeException e) {
            throw new SensitivePropertyProtectionException(String.format("Set Secret [%s] failed", secretName), (Throwable)e);
        }
    }

    public String unprotect(String protectedValue, ProtectedPropertyContext context) throws SensitivePropertyProtectionException {
        String secretName = this.getSecretName(context);
        try {
            KeyVaultSecret keyVaultSecret = this.secretClient.getSecret(secretName);
            return keyVaultSecret.getValue();
        }
        catch (ResourceNotFoundException e) {
            throw new SensitivePropertyProtectionException(String.format("Secret [%s] not found", secretName), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new SensitivePropertyProtectionException(String.format("Secret [%s] request failed", secretName), (Throwable)e);
        }
    }

    public void cleanUp() {
    }

    private String getSecretName(ProtectedPropertyContext context) {
        String contextKey = Objects.requireNonNull(context, "Context required").getContextKey();
        return contextKey.replaceAll(FORWARD_SLASH, DASH).replaceAll(PERIOD, DASH);
    }
}

