/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.expression.condition;

import java.util.ArrayList;
import v14.h2.engine.Session;
import v14.h2.expression.Expression;
import v14.h2.expression.ExpressionColumn;
import v14.h2.expression.ExpressionList;
import v14.h2.expression.ValueExpression;
import v14.h2.expression.condition.SimplePredicate;
import v14.h2.index.IndexCondition;
import v14.h2.table.TableFilter;
import v14.h2.value.Value;
import v14.h2.value.ValueBoolean;
import v14.h2.value.ValueNull;
import v14.h2.value.ValueRow;

public class NullPredicate
extends SimplePredicate {
    private boolean optimized;

    public NullPredicate(Expression expression, boolean bl) {
        super(expression, bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return this.left.getSQL(stringBuilder.append('('), bl).append(this.not ? " IS NOT NULL)" : " IS NULL)");
    }

    @Override
    public Expression optimize(Session session) {
        ExpressionList expressionList;
        if (this.optimized) {
            return this;
        }
        Expression expression = super.optimize(session);
        if (expression != this) {
            return expression;
        }
        this.optimized = true;
        if (this.left instanceof ExpressionList && (expressionList = (ExpressionList)this.left).getType().getValueType() == 39) {
            int n = expressionList.getSubexpressionCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                if (!expressionList.getSubexpression(i).isNullConstant()) continue;
                if (this.not) {
                    return ValueExpression.getBoolean(false);
                }
                ArrayList<Expression> arrayList = new ArrayList<Expression>(n - 1);
                for (n2 = 0; n2 < i; ++n2) {
                    arrayList.add(expressionList.getSubexpression(n2));
                }
                for (n2 = i + 1; n2 < n; ++n2) {
                    Expression expression2 = expressionList.getSubexpression(n2);
                    if (expression2.isNullConstant()) continue;
                    arrayList.add(expression2);
                }
                this.left = arrayList.size() == 1 ? (Expression)arrayList.get(0) : new ExpressionList(arrayList.toArray(new Expression[0]), false);
                break;
            }
        }
        return this;
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        if (value.getType().getValueType() == 39) {
            for (Value value2 : ((ValueRow)value).getList()) {
                if (!(value2 != ValueNull.INSTANCE ^ this.not)) continue;
                return ValueBoolean.FALSE;
            }
            return ValueBoolean.TRUE;
        }
        return ValueBoolean.get(value == ValueNull.INSTANCE ^ this.not);
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        Expression expression = this.optimize(session);
        if (expression != this) {
            return expression.getNotIfPossible(session);
        }
        switch (this.left.getType().getValueType()) {
            case -1: 
            case 39: {
                return null;
            }
        }
        return new NullPredicate(this.left, !this.not);
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        ExpressionList expressionList;
        if (this.not || !tableFilter.getTable().isQueryComparable()) {
            return;
        }
        if (this.left instanceof ExpressionColumn) {
            NullPredicate.createNullIndexCondition(tableFilter, (ExpressionColumn)this.left);
        } else if (this.left instanceof ExpressionList && (expressionList = (ExpressionList)this.left).getType().getValueType() == 39) {
            int n = expressionList.getSubexpressionCount();
            for (int i = 0; i < n; ++i) {
                Expression expression = expressionList.getSubexpression(i);
                if (!(expression instanceof ExpressionColumn)) continue;
                NullPredicate.createNullIndexCondition(tableFilter, (ExpressionColumn)expression);
            }
        }
    }

    private static void createNullIndexCondition(TableFilter tableFilter, ExpressionColumn expressionColumn) {
        if (tableFilter == expressionColumn.getTableFilter() && expressionColumn.getType().getValueType() != 39) {
            tableFilter.addIndexCondition(IndexCondition.get(16, expressionColumn, ValueExpression.getNull()));
        }
    }
}

