/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.PropertyEncryptorBuilder;
import org.apache.nifi.util.NiFiProperties;

public class PropertyEncryptorFactory {
    private static final String KEY_REQUIRED = String.format("NiFi Sensitive Properties Key [%s] is required", "nifi.sensitive.props.key");

    public static PropertyEncryptor getPropertyEncryptor(NiFiProperties properties) {
        Objects.requireNonNull(properties, "NiFi Properties is required");
        String algorithm = properties.getProperty("nifi.sensitive.props.algorithm");
        String password = properties.getProperty("nifi.sensitive.props.key");
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException(KEY_REQUIRED);
        }
        return new PropertyEncryptorBuilder(password).setAlgorithm(algorithm).build();
    }
}

