/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.cached;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.OrderedEntityIdCollection;
import jetbrains.exodus.entitystore.iterate.SortedEntityIdSet;
import jetbrains.exodus.entitystore.iterate.cached.iterator.OrderedEntityIdCollectionIterator;
import jetbrains.exodus.entitystore.iterate.cached.iterator.ReverseOrderedEntityIdCollectionIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleTypeSortedSetEntityIdCachedInstanceIterable
extends CachedInstanceIterable {
    private final int typeId;
    @NotNull
    private final SortedEntityIdSet localIds;

    public SingleTypeSortedSetEntityIdCachedInstanceIterable(@Nullable PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int typeId, @NotNull SortedEntityIdSet localIds) {
        super(txn, source);
        this.typeId = typeId;
        this.localIds = localIds;
    }

    @Override
    public int getEntityTypeId() {
        return this.typeId;
    }

    @Override
    public boolean isSortedById() {
        return true;
    }

    @Override
    protected CachedInstanceIterable orderById() {
        return this;
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.localIds.count();
    }

    @Override
    protected boolean containsImpl(@NotNull EntityId entityId) {
        return this.localIds.contains(entityId);
    }

    @Override
    protected int indexOfImpl(@NotNull EntityId entityId) {
        return this.localIds.indexOf(entityId);
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new OrderedEntityIdCollectionIterator(this, (OrderedEntityIdCollection)this.localIds);
    }

    @Override
    @NotNull
    public EntityIterator getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new ReverseOrderedEntityIdCollectionIterator(this, (OrderedEntityIdCollection)this.localIds);
    }

    @Override
    @NotNull
    public EntityIdSet toSet(@NotNull PersistentStoreTransaction txn) {
        return this.localIds;
    }
}

