/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferStateManager {
    private static final Logger logger = LoggerFactory.getLogger(BufferStateManager.class);
    private ByteBuffer buffer;
    private Direction direction = Direction.WRITE;

    public BufferStateManager(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public BufferStateManager(ByteBuffer buffer, Direction direction) {
        this.buffer = buffer;
        this.direction = direction;
    }

    public void ensureSize(int requiredSize) {
        if (this.buffer.capacity() < requiredSize) {
            ByteBuffer newBuffer = ByteBuffer.allocate(requiredSize);
            if (this.direction == Direction.WRITE) {
                this.buffer.flip();
            }
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
            this.direction = Direction.WRITE;
        }
    }

    public ByteBuffer prepareForWrite(int requiredSize) {
        this.ensureSize(requiredSize);
        if (this.direction == Direction.READ) {
            this.direction = Direction.WRITE;
            this.buffer.position(this.buffer.limit());
        }
        this.buffer.limit(this.buffer.capacity());
        return this.buffer;
    }

    public ByteBuffer prepareForRead(int requiredSize) {
        this.ensureSize(requiredSize);
        if (this.direction == Direction.WRITE) {
            this.direction = Direction.READ;
            this.buffer.flip();
        }
        return this.buffer;
    }

    public void clear() {
        logger.debug("Clearing {}", (Object)this.buffer);
        this.buffer.clear();
        this.direction = Direction.WRITE;
    }

    public void compact() {
        String before = this.buffer.toString();
        this.buffer.compact();
        logger.debug("Before compact: {}, after: {}", (Object)before, (Object)this.buffer);
        this.direction = Direction.WRITE;
    }

    public static enum Direction {
        READ,
        WRITE;

    }
}

