/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.LongIterator;
import jetbrains.exodus.tree.TreeTraverser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddressIterator
implements LongIterator {
    @NotNull
    private final TreeTraverser traverser;
    @Nullable
    private ITree root;
    private boolean canGoDown = true;
    private boolean alreadyIn;

    public AddressIterator(@Nullable ITree root, boolean alreadyIn, @NotNull TreeTraverser traverser) {
        this.root = root;
        this.alreadyIn = alreadyIn;
        this.traverser = traverser;
    }

    @Override
    public boolean hasNext() {
        return this.traverser.canMoveRight() || this.advance() || this.root != null;
    }

    @Override
    public long next() {
        if (this.alreadyIn) {
            this.alreadyIn = false;
            return this.traverser.getCurrentAddress();
        }
        if (this.canGoDown) {
            if (this.traverser.canMoveDown()) {
                this.traverser.moveDown();
                return this.traverser.getCurrentAddress();
            }
        } else {
            this.canGoDown = true;
        }
        if (this.traverser.canMoveRight()) {
            this.traverser.moveRight();
            long result = this.traverser.getCurrentAddress();
            if (this.traverser.canMoveDown()) {
                this.traverser.moveDown();
                this.alreadyIn = true;
            }
            return result;
        }
        if (this.traverser.canMoveUp()) {
            this.traverser.moveUp();
            this.canGoDown = false;
            return this.traverser.getCurrentAddress();
        }
        if (this.root != null) {
            long result = this.root.getRootAddress();
            this.root = null;
            return result;
        }
        return -1L;
    }

    @NotNull
    public TreeTraverser getTraverser() {
        return this.traverser;
    }

    public void skipSubTree() {
    }

    protected boolean advance() {
        while (this.traverser.canMoveUp()) {
            if (this.traverser.canMoveRight()) {
                return true;
            }
            this.traverser.moveUp();
            this.canGoDown = false;
        }
        return this.traverser.canMoveRight();
    }
}

