/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Chars;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.ByteSequence;
import io.questdb.std.str.DirectByteCharSequence;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ByteCharSequence
extends AbstractCharSequence
implements ByteSequence {
    private final byte[] bytes;

    public ByteCharSequence(byte[] bytes) {
        this.bytes = bytes;
    }

    public static ByteCharSequence newInstance(DirectByteCharSequence src) {
        byte[] bytes = new byte[src.length()];
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            bytes[i] = src.byteAt(i);
        }
        return new ByteCharSequence(bytes);
    }

    @Override
    public byte byteAt(int index) {
        return this.bytes[index];
    }

    @Override
    public char charAt(int index) {
        return (char)this.byteAt(index);
    }

    public int intAt(int index) {
        return Unsafe.byteArrayGetInt(this.bytes, index);
    }

    @Override
    public int length() {
        return this.bytes.length;
    }

    public long longAt(int index) {
        return Unsafe.byteArrayGetLong(this.bytes, index);
    }

    @Override
    @NotNull
    public String toString() {
        return Chars.stringFromUtf8Bytes(this);
    }

    @Override
    protected CharSequence _subSequence(int start, int end) {
        return new ByteCharSequence(Arrays.copyOfRange(this.bytes, start, end));
    }
}

