/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.rnd.RndStringListFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Sinkable;

public class ListFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "list(V)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        ObjList<String> symbols = new ObjList<String>(args.size());
        RndStringListFunctionFactory.copyConstants(args, argPositions, symbols);
        return new Func(symbols);
    }

    private static final class Func
    extends SymbolFunction
    implements Function {
        private final int count;
        private final ObjList<String> symbols;
        private int position = 0;

        public Func(ObjList<String> symbols) {
            this.symbols = symbols;
            this.count = symbols.size();
        }

        @Override
        public int getInt(Record rec) {
            return this.next();
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            return this.symbols.getQuick(this.next());
        }

        @Override
        public CharSequence getSymbolB(Record rec) {
            return this.getSymbol(rec);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.position = 0;
        }

        @Override
        public boolean isSymbolTableStatic() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("list(").val((Sinkable)this.symbols).val(')');
        }

        @Override
        public CharSequence valueBOf(int key) {
            return this.valueOf(key);
        }

        @Override
        public CharSequence valueOf(int symbolKey) {
            return this.symbols.getQuick(TableUtils.toIndexKey(symbolKey));
        }

        private int next() {
            return this.position++ % this.count;
        }
    }
}

