/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.SqlException;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.std.IntStack;
import java.util.ArrayDeque;

public final class PostOrderTreeTraversalAlgo {
    private final IntStack backupDepth = new IntStack();
    private final IntStack indexStack = new IntStack();
    private final IntStack indexStackBackup = new IntStack();
    private final ArrayDeque<ExpressionNode> stack = new ArrayDeque();
    private final ArrayDeque<ExpressionNode> stackBackup = new ArrayDeque();

    public void backup() {
        int size = this.stack.size();
        this.backupDepth.push(size);
        for (int i = 0; i < size; ++i) {
            this.stackBackup.push(this.stack.poll());
            this.indexStackBackup.push(this.indexStack.pop());
        }
    }

    public void restore() {
        if (this.backupDepth.size() > 0) {
            int size = this.backupDepth.pop();
            for (int i = 0; i < size; ++i) {
                this.stack.push(this.stackBackup.poll());
                this.indexStack.push(this.indexStackBackup.pop());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverse(ExpressionNode node, Visitor visitor) throws SqlException {
        this.backup();
        try {
            this.stack.clear();
            this.indexStack.clear();
            ExpressionNode lastVisited = null;
            while (!this.stack.isEmpty() || node != null) {
                if (node != null) {
                    if (!visitor.descend(node)) {
                        lastVisited = node;
                        node = null;
                        continue;
                    }
                    this.stack.push(node);
                    this.indexStack.push(0);
                    node = node.rhs;
                    continue;
                }
                ExpressionNode peek = this.stack.peek();
                assert (peek != null);
                if (peek.paramCount < 3) {
                    if (peek.lhs != null && lastVisited != peek.lhs) {
                        node = peek.lhs;
                        continue;
                    }
                    visitor.visit(peek);
                    lastVisited = this.stack.poll();
                    this.indexStack.pop();
                    continue;
                }
                int index = this.indexStack.peek();
                if (index < peek.paramCount) {
                    node = peek.args.getQuick(index);
                    this.indexStack.update(index + 1);
                    continue;
                }
                visitor.visit(peek);
                lastVisited = this.stack.poll();
                this.indexStack.pop();
            }
        }
        finally {
            this.restore();
        }
    }

    public static interface Visitor {
        default public boolean descend(ExpressionNode node) throws SqlException {
            return true;
        }

        public void visit(ExpressionNode var1) throws SqlException;
    }
}

