/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.apache.nifi.security.util.crypto.SecureHasher;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecureHasher
implements SecureHasher {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSecureHasher.class);
    protected int saltLength;
    private boolean usingStaticSalt;
    private static final byte[] STATIC_SALT = "NiFi Static Salt".getBytes(StandardCharsets.UTF_8);
    static final Integer UPPER_BOUNDARY = Double.valueOf(Math.pow(2.0, 32.0)).intValue() - 1;

    protected void initializeSalt(Integer saltLength) {
        if (saltLength > 0) {
            if (!this.isSaltLengthValid(saltLength)) {
                logger.error("The salt length {} is outside the boundary of {} to {}.", new Object[]{saltLength, this.getMinSaltLength(), this.getMaxSaltLength()});
                throw new IllegalArgumentException("Invalid salt length exceeds the saltLength boundary.");
            }
            this.usingStaticSalt = false;
        } else {
            this.usingStaticSalt = true;
            logger.debug("Configured to use static salt");
        }
    }

    public boolean isSaltLengthValid(Integer saltLength) {
        int SALT_LENGTH = this.getDefaultSaltLength();
        if (saltLength == 0) {
            logger.debug("The provided salt length 0 indicates a static salt of {} bytes", (Object)SALT_LENGTH);
            return true;
        }
        if (saltLength < SALT_LENGTH) {
            logger.warn("The provided dynamic salt length {} is below the recommended minimum {}", (Object)saltLength, (Object)SALT_LENGTH);
        }
        return saltLength >= this.getMinSaltLength() && saltLength <= this.getMaxSaltLength();
    }

    abstract int getDefaultSaltLength();

    abstract int getMinSaltLength();

    abstract int getMaxSaltLength();

    public boolean isUsingStaticSalt() {
        return this.usingStaticSalt;
    }

    byte[] getSalt() {
        if (this.isUsingStaticSalt()) {
            return STATIC_SALT;
        }
        SecureRandom sr = new SecureRandom();
        byte[] salt = new byte[this.saltLength];
        sr.nextBytes(salt);
        return salt;
    }

    abstract String getAlgorithmName();

    abstract boolean acceptsEmptyInput();

    @Override
    public String hashHex(String input) {
        try {
            input = this.validateInput(input);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        return Hex.toHexString((byte[])this.hash(input.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String hashHex(String input, String salt) {
        try {
            input = this.validateInput(input);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        return Hex.toHexString((byte[])this.hash(input.getBytes(StandardCharsets.UTF_8), salt.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String hashBase64(String input) {
        try {
            input = this.validateInput(input);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        return CipherUtility.encodeBase64NoPadding(this.hash(input.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String hashBase64(String input, String salt) {
        try {
            input = this.validateInput(input);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        return CipherUtility.encodeBase64NoPadding(this.hash(input.getBytes(StandardCharsets.UTF_8), salt.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public byte[] hashRaw(byte[] input) {
        return this.hash(input);
    }

    @Override
    public byte[] hashRaw(byte[] input, byte[] salt) {
        return this.hash(input, salt);
    }

    private String validateInput(String input) {
        if (this.acceptsEmptyInput()) {
            if (input == null) {
                logger.warn("Attempting to generate a hash using {} of null input; using empty input", (Object)this.getAlgorithmName());
                return "";
            }
        } else if (input == null || input.length() == 0) {
            logger.warn("Attempting to generate a hash using {} of null or empty input; returning 0 length string", (Object)this.getAlgorithmName());
            throw new IllegalArgumentException();
        }
        return input;
    }

    abstract byte[] hash(byte[] var1);

    abstract byte[] hash(byte[] var1, byte[] var2);
}

