/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.List;
import java.util.Objects;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.ValueMapper;
import org.apache.nifi.controller.status.history.ValueReducer;

public enum NodeStatusDescriptor {
    FREE_HEAP("freeHeap", "Free Heap", "The amount of free memory in the heap that can be used by the Java virtual machine.", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getFreeHeap())),
    USED_HEAP("usedHeap", "Used Heap", "The amount of used memory in the heap that is used by the Java virtual machine.", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getUsedHeap())),
    HEAP_UTILIZATION("heapUtilization", "Heap Utilization", "The percentage of available heap currently used by the Java virtual machine.", MetricDescriptor.Formatter.COUNT, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getHeapUtilization()), new ValueReducer<StatusSnapshot, Long>(){

        public Long reduce(List<StatusSnapshot> values) {
            return (long)values.stream().map(snapshot -> snapshot.getStatusMetric(HEAP_UTILIZATION.getDescriptor())).filter(Objects::nonNull).mapToLong(value -> value).average().orElse(0.0);
        }
    }),
    FREE_NON_HEAP("freeNonHeap", "Free Non Heap", "The currently available non-heap memory that can be used by the Java virtual machine.", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getFreeNonHeap())),
    USED_NON_HEAP("usedNonHeap", "Used Non Heap", "The current usage of non-heap memory that is used by the Java virtual machine.", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getUsedNonHeap())),
    OPEN_FILE_HANDLES("openFileHandles", "Open File Handles", "The current number of open file handles used by the Java virtual machine.", MetricDescriptor.Formatter.COUNT, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getOpenFileHandlers())),
    PROCESSOR_LOAD_AVERAGE("processorLoadAverage", "Processor Load Average", "The processor load. Every measurement point represents the system load average for the last minute.", MetricDescriptor.Formatter.FRACTION, (ValueMapper<NodeStatus>)((ValueMapper)s -> Double.valueOf(s.getProcessorLoadAverage() * 1000000.0).longValue()), new ValueReducer<StatusSnapshot, Long>(){

        public Long reduce(List<StatusSnapshot> values) {
            return (long)values.stream().map(snapshot -> snapshot.getStatusMetric(HEAP_UTILIZATION.getDescriptor())).filter(Objects::nonNull).mapToLong(value -> value).average().orElse(0.0);
        }
    }),
    TOTAL_THREADS("totalThreads", "Number of total threads", "The current number of live threads in the Java virtual machine (both daemon and non-daemon threads).", MetricDescriptor.Formatter.COUNT, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getTotalThreads())),
    EVENT_DRIVEN_THREADS("eventDrivenThreads", "Number of event driven threads", "The current number of active threads in the event driven thread pool.", MetricDescriptor.Formatter.COUNT, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getEventDrivenThreads())),
    TIME_DRIVEN_THREADS("timeDrivenThreads", "Number of time driven threads", "The current number of active threads in the time driven thread pool.", MetricDescriptor.Formatter.COUNT, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getTimerDrivenThreads())),
    FLOW_FILE_REPOSITORY_FREE_SPACE("flowFileRepositoryFreeSpace", "Flow File Repository Free Space", "The usable space available for file repositories on the underlying storage mechanism", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getFlowFileRepositoryFreeSpace())),
    FLOW_FILE_REPOSITORY_USED_SPACE("flowFileRepositoryUsedSpace", "Flow File Repository Used Space", "The space in use on the underlying storage mechanism.", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getFlowFileRepositoryUsedSpace())),
    CONTENT_REPOSITORY_FREE_SPACE("contentRepositoryFreeSpace", "Sum content Repository Free Space", "The usable space available for content repositories on the underlying storage mechanisms.", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getContentRepositories().stream().mapToLong(r -> r.getFreeSpace()).sum())),
    CONTENT_REPOSITORY_USED_SPACE("contentRepositoryUsedSpace", "Sum content Repository Used Space", "The space in use on the underlying storage mechanisms.", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getContentRepositories().stream().mapToLong(r -> r.getUsedSpace()).sum())),
    PROVENANCE_REPOSITORY_FREE_SPACE("provenanceRepositoryFreeSpace", "Sum provenance Repository Free Space", "The usable space available for use by the underlying storage mechanisms.", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getProvenanceRepositories().stream().mapToLong(r -> r.getFreeSpace()).sum())),
    PROVENANCE_REPOSITORY_USED_SPACE("provenanceRepositoryUsedSpace", "Sum provenance Repository Used Space", "The space in use on the underlying storage mechanisms.", MetricDescriptor.Formatter.DATA_SIZE, (ValueMapper<NodeStatus>)((ValueMapper)s -> s.getProvenanceRepositories().stream().mapToLong(r -> r.getUsedSpace()).sum()));

    private final MetricDescriptor<NodeStatus> descriptor;

    private NodeStatusDescriptor(String field, String label, String description, MetricDescriptor.Formatter formatter, ValueMapper<NodeStatus> valueFunction) {
        this.descriptor = new StandardMetricDescriptor<NodeStatus>(this::ordinal, field, label, description, formatter, valueFunction);
    }

    private NodeStatusDescriptor(String field, String label, String description, MetricDescriptor.Formatter formatter, ValueMapper<NodeStatus> valueFunction, ValueReducer<StatusSnapshot, Long> reducer) {
        this.descriptor = new StandardMetricDescriptor<NodeStatus>(this::ordinal, field, label, description, formatter, valueFunction, reducer);
    }

    public String getField() {
        return this.descriptor.getField();
    }

    public MetricDescriptor<NodeStatus> getDescriptor() {
        return this.descriptor;
    }
}

