/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.scheduling.RepositoryContextFactory;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.util.FormatUtils;

public class RepositoryDiagnosticTask
implements DiagnosticTask {
    private final FlowController flowController;

    public RepositoryDiagnosticTask(FlowController flowController) {
        this.flowController = flowController;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        ArrayList<String> details = new ArrayList<String>();
        RepositoryContextFactory contextFactory = this.flowController.getRepositoryContextFactory();
        ProcessGroupStatus rootGroupStatus = this.flowController.getEventAccess().getGroupStatus(this.flowController.getFlowManager().getRootGroupId());
        try {
            this.captureDiagnostics(contextFactory.getFlowFileRepository(), details);
        }
        catch (IOException ioe) {
            details.add("Failed to gather details about FlowFile Repository");
        }
        try {
            details.add("");
            this.captureDiagnostics(contextFactory.getContentRepository(), rootGroupStatus, details);
        }
        catch (IOException ioe) {
            details.add("Failed to gather details about Content Repository");
        }
        try {
            details.add("");
            this.captureDiagnostics(contextFactory.getProvenanceRepository(), details);
        }
        catch (IOException ioe) {
            details.add("Failed to gather details about Provenance Repository");
        }
        return new StandardDiagnosticsDumpElement("NiFi Repositories", details);
    }

    private void captureDiagnostics(FlowFileRepository repository, List<String> details) throws IOException {
        details.add("FlowFile Repository Implementation: " + repository.getClass().getName());
        details.add("FlowFile Repository File Store: " + repository.getFileStoreName());
        details.add("FlowFile Repository Storage Capacity: " + FormatUtils.formatDataSize((double)repository.getStorageCapacity()));
        details.add("FlowFile Repository Usable Space: " + FormatUtils.formatDataSize((double)repository.getUsableStorageSpace()));
    }

    private void captureDiagnostics(ContentRepository repository, ProcessGroupStatus status, List<String> details) throws IOException {
        details.add("Content Repository Implementation: " + repository.getClass().getName());
        for (String containerName : repository.getContainerNames()) {
            details.add("Content Repository <" + containerName + "> File Store: " + repository.getContainerFileStoreName(containerName));
            details.add("Content Repository <" + containerName + "> Storage Capacity: " + FormatUtils.formatDataSize((double)repository.getContainerCapacity(containerName)));
            details.add("Content Repository <" + containerName + "> Usable Space: " + FormatUtils.formatDataSize((double)repository.getContainerUsableSpace(containerName)));
        }
        details.add("Bytes Read (Last 5 mins): " + FormatUtils.formatDataSize((double)status.getBytesRead().longValue()));
        details.add("Bytes Written (Last 5 mins): " + FormatUtils.formatDataSize((double)status.getBytesWritten().longValue()));
    }

    private void captureDiagnostics(ProvenanceRepository repository, List<String> details) throws IOException {
        details.add("Provenance Repository Implementation: " + repository.getClass().getName());
        for (String containerName : repository.getContainerNames()) {
            details.add("Provenance Repository <" + containerName + "> File Store: " + repository.getContainerFileStoreName(containerName));
            details.add("Provenance Repository <" + containerName + "> Storage Capacity: " + FormatUtils.formatDataSize((double)repository.getContainerCapacity(containerName)));
            details.add("Provenance Repository <" + containerName + "> Usable Space: " + FormatUtils.formatDataSize((double)repository.getContainerUsableSpace(containerName)));
        }
    }
}

