/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.storage.questdb;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.history.ComponentDetailsStorage;
import org.apache.nifi.controller.status.history.ConnectionStatusDescriptor;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.questdb.QuestDbContext;
import org.apache.nifi.controller.status.history.storage.questdb.QuestDbComponentStatusStorage;

public class QuestDbConnectionStatusStorage
extends QuestDbComponentStatusStorage<ConnectionStatus> {
    private static final Map<Integer, MetricDescriptor<ConnectionStatus>> METRICS = new HashMap<Integer, MetricDescriptor<ConnectionStatus>>();

    public QuestDbConnectionStatusStorage(QuestDbContext dbContext, ComponentDetailsStorage componentDetails) {
        super(dbContext, componentDetails);
    }

    @Override
    protected String extractId(ConnectionStatus statusEntry) {
        return statusEntry.getId();
    }

    @Override
    protected Map<Integer, MetricDescriptor<ConnectionStatus>> getMetrics() {
        return METRICS;
    }

    @Override
    protected String getTableName() {
        return "connectionStatus";
    }

    static {
        METRICS.put(2, ConnectionStatusDescriptor.INPUT_BYTES.getDescriptor());
        METRICS.put(3, ConnectionStatusDescriptor.INPUT_COUNT.getDescriptor());
        METRICS.put(4, ConnectionStatusDescriptor.OUTPUT_BYTES.getDescriptor());
        METRICS.put(5, ConnectionStatusDescriptor.OUTPUT_COUNT.getDescriptor());
        METRICS.put(6, ConnectionStatusDescriptor.QUEUED_BYTES.getDescriptor());
        METRICS.put(7, ConnectionStatusDescriptor.QUEUED_COUNT.getDescriptor());
        METRICS.put(8, ConnectionStatusDescriptor.TOTAL_QUEUED_DURATION.getDescriptor());
        METRICS.put(9, ConnectionStatusDescriptor.MAX_QUEUED_DURATION.getDescriptor());
        METRICS.put(10, ConnectionStatusDescriptor.AVERAGE_QUEUED_DURATION.getDescriptor());
    }
}

