/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.CounterRepository;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.RepositoryContext;
import org.apache.nifi.controller.repository.StandardRepositoryContext;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceRepository;

public class RepositoryContextFactory {
    private final ContentRepository contentRepo;
    private final FlowFileRepository flowFileRepo;
    private final FlowFileEventRepository flowFileEventRepo;
    private final CounterRepository counterRepo;
    private final ProvenanceRepository provenanceRepo;
    private final StateManagerProvider stateManagerProvider;

    public RepositoryContextFactory(ContentRepository contentRepository, FlowFileRepository flowFileRepository, FlowFileEventRepository flowFileEventRepository, CounterRepository counterRepository, ProvenanceRepository provenanceRepository, StateManagerProvider stateManagerProvider) {
        this.contentRepo = contentRepository;
        this.flowFileRepo = flowFileRepository;
        this.flowFileEventRepo = flowFileEventRepository;
        this.counterRepo = counterRepository;
        this.provenanceRepo = provenanceRepository;
        this.stateManagerProvider = stateManagerProvider;
    }

    public RepositoryContext newProcessContext(Connectable connectable, AtomicLong connectionIndex) {
        StateManager stateManager = this.stateManagerProvider.getStateManager(connectable.getIdentifier());
        return new StandardRepositoryContext(connectable, connectionIndex, this.contentRepo, this.flowFileRepo, this.flowFileEventRepo, this.counterRepo, (ProvenanceEventRepository)this.provenanceRepo, stateManager);
    }

    public ContentRepository getContentRepository() {
        return this.contentRepo;
    }

    public FlowFileRepository getFlowFileRepository() {
        return this.flowFileRepo;
    }

    public ProvenanceRepository getProvenanceRepository() {
        return this.provenanceRepo;
    }
}

