/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.commons.server.TempStoreOutputStream;
import org.apache.chemistry.opencmis.server.shared.RequestAwareTempStoreOutputStream;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStream;

public class TempStoreOutputStreamFactory {
    private CmisServiceFactory factory;
    private String repositoryId;
    private HttpServletRequest request;
    private File tempDir;
    private int memoryThreshold;
    private long maxContentSize;
    private boolean encrypt;

    protected TempStoreOutputStreamFactory(CmisServiceFactory factory, String repositoryId, HttpServletRequest request) {
        this.factory = factory;
        this.repositoryId = repositoryId;
        this.tempDir = factory.getTempDirectory();
        this.memoryThreshold = factory.getMemoryThreshold();
        this.maxContentSize = factory.getMaxContentSize();
        this.encrypt = factory.encryptTempFiles();
        this.request = request;
    }

    protected TempStoreOutputStreamFactory(File tempDir, int memoryThreshold, long maxContentSize, boolean encrypt) {
        this.factory = null;
        this.repositoryId = null;
        this.tempDir = tempDir;
        this.memoryThreshold = memoryThreshold;
        this.maxContentSize = maxContentSize;
        this.encrypt = encrypt;
    }

    public static TempStoreOutputStreamFactory newInstance(CmisServiceFactory factory, String repositoryId, HttpServletRequest request) {
        return new TempStoreOutputStreamFactory(factory, repositoryId, request);
    }

    public static TempStoreOutputStreamFactory newInstance(File tempDir, int memoryThreshold, long maxContentSize, boolean encrypt) {
        return new TempStoreOutputStreamFactory(tempDir, memoryThreshold, maxContentSize, encrypt);
    }

    public TempStoreOutputStream newOutputStream() {
        TempStoreOutputStream stream = null;
        if (this.factory != null) {
            stream = this.factory.getTempFileOutputStream(this.repositoryId);
        }
        if (stream == null) {
            stream = new ThresholdOutputStream(this.tempDir, this.memoryThreshold, this.maxContentSize, this.encrypt);
        } else if (stream instanceof RequestAwareTempStoreOutputStream) {
            ((RequestAwareTempStoreOutputStream)stream).setHttpServletRequest(this.request);
        }
        return stream;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public long getMaxContentSize() {
        return this.maxContentSize;
    }

    public boolean isEncrypted() {
        return this.encrypt;
    }
}

