/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractColorFunction;
import com.github.sommeri.less4j.core.compiler.expressions.CssNameClashMultiParameterFunction;
import com.github.sommeri.less4j.core.compiler.expressions.UnknownFunction;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class Contrast
extends CssNameClashMultiParameterFunction {
    Contrast() {
    }

    @Override
    public Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression call, Expression evaluatedParameter) {
        if (splitParameters.get(0).getType() != ASTCssNodeType.COLOR_EXPRESSION) {
            UnknownFunction unknownFunction = new UnknownFunction();
            return unknownFunction.evaluate(splitParameters, problemsHandler, call, evaluatedParameter);
        }
        HiddenTokenAwareTree token = call.getUnderlyingStructure();
        ColorExpression color = (ColorExpression)splitParameters.get(0);
        Expression dark = splitParameters.size() > 1 ? splitParameters.get(1) : new ColorExpression(token, 0.0, 0.0, 0.0);
        Expression light = splitParameters.size() > 2 ? splitParameters.get(2) : new ColorExpression(token, 255.0, 255.0, 255.0);
        Expression threshold = splitParameters.size() > 3 ? splitParameters.get(3) : new NumberExpression(token, 43.0, "%", null, NumberExpression.Dimension.PERCENTAGE);
        double thresholdValue = AbstractColorFunction.number(threshold);
        if (this.luma((ColorExpression)dark) > this.luma((ColorExpression)light)) {
            Expression t = light;
            light = dark;
            dark = t;
        }
        if (this.luma(color) < thresholdValue) {
            return light;
        }
        return dark;
    }

    private double luma(ColorExpression color) {
        double r = color.getRed() / 255.0;
        double g = color.getGreen() / 255.0;
        double b = color.getBlue() / 255.0;
        r = r <= 0.03928 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.03928 ? g / 12.92 : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.03928 ? b / 12.92 : Math.pow((b + 0.055) / 1.055, 2.4);
        return (0.2126 * r + 0.7152 * g + 0.0722 * b) * color.getAlpha();
    }

    @Override
    protected int getMinParameters() {
        return 1;
    }

    @Override
    protected int getMaxParameters() {
        return 4;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        switch (position) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.COLOR_EXPRESSION);
            }
            case 3: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.NUMBER);
            }
        }
        return false;
    }

    @Override
    protected String getName() {
        return "contrast";
    }
}

