/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import org.apache.sis.internal.util.SetOfUnknownSize;

public abstract class ListOfUnknownSize<E>
extends AbstractSequentialList<E> {
    protected ListOfUnknownSize() {
    }

    protected int sizeIfKnown() {
        return -1;
    }

    @Override
    public int size() {
        int n;
        block1: {
            n = this.sizeIfKnown();
            if (n >= 0) break block1;
            n = 0;
            while (this.exists(n) && ++n != Integer.MAX_VALUE) {
            }
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        int n = this.sizeIfKnown();
        return n == 0 || n < 0 && !this.exists(0);
    }

    protected abstract boolean exists(int var1);

    @Override
    public abstract E get(int var1);

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        java.util.Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.remove(iterator.next());
        }
        return bl;
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new Iterator(n);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.sizeIfKnown() >= 0 ? super.spliterator() : Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    @Override
    public Object[] toArray() {
        return this.sizeIfKnown() >= 0 ? super.toArray() : SetOfUnknownSize.toArray(this.iterator(), new Object[32], true);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.sizeIfKnown() >= 0 ? super.toArray(TArray) : SetOfUnknownSize.toArray(this.iterator(), TArray, false);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        java.util.Iterator iterator = this.iterator();
        java.util.Iterator iterator2 = ((List)object).iterator();
        while (iterator.hasNext()) {
            if (iterator2.hasNext() && Objects.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    private final class Iterator
    implements ListIterator<E> {
        private int cursor;

        Iterator(int n) {
            this.cursor = n;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public boolean hasNext() {
            int n = ListOfUnknownSize.this.sizeIfKnown();
            return n >= 0 ? this.cursor < n : ListOfUnknownSize.this.exists(this.cursor);
        }

        @Override
        public E next() {
            Object e;
            try {
                e = ListOfUnknownSize.this.get(this.cursor);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw (NoSuchElementException)new NoSuchElementException().initCause(indexOutOfBoundsException);
            }
            ++this.cursor;
            return e;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            if (this.cursor != 0) {
                return ListOfUnknownSize.this.get(--this.cursor);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

