/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.Cluster;
import org.apache.solr.common.util.NamedList;

public class ClusteringResponse {
    public static final String CLUSTERS_NODE = "clusters";
    public static final String LABELS_NODE = "labels";
    public static final String DOCS_NODE = "docs";
    public static final String SCORE_NODE = "score";
    public static final String IS_OTHER_TOPICS = "other-topics";
    private List<Cluster> clusters = new ArrayList<Cluster>();

    public ClusteringResponse(List<NamedList<Object>> clusterInfo) {
        for (NamedList<Object> clusterNode : clusterInfo) {
            List docIdList;
            List<Cluster> subclusters = Collections.emptyList();
            List labelList = docIdList = Collections.emptyList();
            Double score = 0.0;
            boolean otherTopics = false;
            for (Map.Entry<String, Object> entry : clusterNode) {
                switch (entry.getKey()) {
                    case "labels": {
                        labelList = (List)entry.getValue();
                        break;
                    }
                    case "docs": {
                        docIdList = (List)entry.getValue();
                        break;
                    }
                    case "score": {
                        score = ((Number)entry.getValue()).doubleValue();
                        break;
                    }
                    case "clusters": {
                        subclusters = new ClusteringResponse((List)entry.getValue()).getClusters();
                        break;
                    }
                    case "other-topics": {
                        otherTopics = (Boolean)entry.getValue();
                    }
                }
            }
            this.clusters.add(new Cluster(labelList, score, docIdList, subclusters, otherTopics));
        }
    }

    public List<Cluster> getClusters() {
        return this.clusters;
    }
}

