/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.logging;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public abstract class Logger {
    private static Constructor loggerConstructor = null;

    public static void setLoggerType(LoggerType loggerType) {
        try {
            Class<?> loggerClass = null;
            if (loggerType == LoggerType.JUL) {
                loggerClass = Logger.class.getClassLoader().loadClass("org.jboss.resteasy.logging.impl.JULLogger");
            } else if (loggerType == LoggerType.LOG4J) {
                loggerClass = Logger.class.getClassLoader().loadClass("org.jboss.resteasy.logging.impl.Log4jLogger");
            } else if (loggerType == LoggerType.SLF4J) {
                loggerClass = Logger.class.getClassLoader().loadClass("org.jboss.resteasy.logging.impl.Slf4jLogger");
            }
            if (loggerClass == null) {
                throw new RuntimeException(Messages.MESSAGES.couldNotMatchUpLoggerTypeImplementation(loggerType));
            }
            loggerConstructor = loggerClass.getDeclaredConstructor(String.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean classInClasspath(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        try {
            return (Logger)loggerConstructor.newInstance(clazz.getName());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract boolean isTraceEnabled();

    public abstract void trace(String var1);

    public abstract void trace(String var1, Object ... var2);

    public abstract void trace(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract void debug(String var1);

    public abstract void debug(String var1, Object ... var2);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Object ... var2);

    public abstract void info(String var1, Throwable var2);

    public abstract boolean isWarnEnabled();

    public abstract void warn(String var1);

    public abstract void warn(String var1, Object ... var2);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Object ... var2);

    public abstract void error(String var1, Throwable var2);

    static {
        LoggerType type = LoggerType.JUL;
        if (Logger.classInClasspath("org.apache.log4j.Logger")) {
            type = LoggerType.LOG4J;
        } else if (Logger.classInClasspath("org.slf4j.Logger")) {
            type = LoggerType.SLF4J;
        }
        Logger.setLoggerType(type);
    }

    public static enum LoggerType {
        JUL,
        LOG4J,
        SLF4J;

    }
}

