/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClusterStateRequest
extends MasterNodeReadOperationRequest<ClusterStateRequest> {
    private boolean routingTable = true;
    private boolean nodes = true;
    private boolean metaData = true;
    private boolean blocks = true;
    private String[] indices = Strings.EMPTY_ARRAY;
    private String[] indexTemplates = Strings.EMPTY_ARRAY;

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public ClusterStateRequest all() {
        this.routingTable = true;
        this.nodes = true;
        this.metaData = true;
        this.blocks = true;
        this.indices = Strings.EMPTY_ARRAY;
        this.indexTemplates = Strings.EMPTY_ARRAY;
        return this;
    }

    public ClusterStateRequest clear() {
        this.routingTable = false;
        this.nodes = false;
        this.metaData = false;
        this.blocks = false;
        this.indices = Strings.EMPTY_ARRAY;
        this.indexTemplates = Strings.EMPTY_ARRAY;
        return this;
    }

    public boolean routingTable() {
        return this.routingTable;
    }

    public ClusterStateRequest routingTable(boolean routingTable) {
        this.routingTable = routingTable;
        return this;
    }

    public boolean nodes() {
        return this.nodes;
    }

    public ClusterStateRequest nodes(boolean nodes) {
        this.nodes = nodes;
        return this;
    }

    public boolean metaData() {
        return this.metaData;
    }

    public ClusterStateRequest metaData(boolean metaData) {
        this.metaData = metaData;
        return this;
    }

    public boolean blocks() {
        return this.blocks;
    }

    public ClusterStateRequest blocks(boolean blocks) {
        this.blocks = blocks;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public ClusterStateRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public String[] indexTemplates() {
        return this.indexTemplates;
    }

    public ClusterStateRequest indexTemplates(String ... indexTemplates) {
        this.indexTemplates = indexTemplates;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.routingTable = in.readBoolean();
        this.nodes = in.readBoolean();
        this.metaData = in.readBoolean();
        this.blocks = in.readBoolean();
        this.indices = in.readStringArray();
        this.indexTemplates = in.readStringArray();
        this.readLocal(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.routingTable);
        out.writeBoolean(this.nodes);
        out.writeBoolean(this.metaData);
        out.writeBoolean(this.blocks);
        out.writeStringArray(this.indices);
        out.writeStringArray(this.indexTemplates);
        this.writeLocal(out);
    }
}

