/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import com.vividsolutions.jts.index.chain.MonotoneChainBuilder;
import com.vividsolutions.jts.index.chain.MonotoneChainOverlapAction;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentSetMutualIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MCIndexSegmentSetMutualIntersector
extends SegmentSetMutualIntersector {
    private List monoChains = new ArrayList();
    private SpatialIndex index = new STRtree();
    private int indexCounter = 0;
    private int processCounter = 0;
    private int nOverlaps = 0;

    public List getMonotoneChains() {
        return this.monoChains;
    }

    public SpatialIndex getIndex() {
        return this.index;
    }

    public void setBaseSegments(Collection segStrings) {
        Iterator i = segStrings.iterator();
        while (i.hasNext()) {
            this.addToIndex((SegmentString)i.next());
        }
    }

    private void addToIndex(SegmentString segStr) {
        List segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        for (MonotoneChain mc : segChains) {
            mc.setId(this.indexCounter++);
            this.index.insert(mc.getEnvelope(), mc);
        }
    }

    public void process(Collection segStrings) {
        this.processCounter = this.indexCounter + 1;
        this.nOverlaps = 0;
        this.monoChains.clear();
        Iterator i = segStrings.iterator();
        while (i.hasNext()) {
            this.addToMonoChains((SegmentString)i.next());
        }
        this.intersectChains();
    }

    private void intersectChains() {
        SegmentOverlapAction overlapAction = new SegmentOverlapAction(this.segInt);
        for (MonotoneChain queryChain : this.monoChains) {
            List overlapChains = this.index.query(queryChain.getEnvelope());
            for (MonotoneChain testChain : overlapChains) {
                queryChain.computeOverlaps(testChain, overlapAction);
                ++this.nOverlaps;
                if (!this.segInt.isDone()) continue;
                return;
            }
        }
    }

    private void addToMonoChains(SegmentString segStr) {
        List segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        for (MonotoneChain mc : segChains) {
            mc.setId(this.processCounter++);
            this.monoChains.add(mc);
        }
    }

    public class SegmentOverlapAction
    extends MonotoneChainOverlapAction {
        private SegmentIntersector si = null;

        public SegmentOverlapAction(SegmentIntersector si) {
            this.si = si;
        }

        public void overlap(MonotoneChain mc1, int start1, MonotoneChain mc2, int start2) {
            SegmentString ss1 = (SegmentString)mc1.getContext();
            SegmentString ss2 = (SegmentString)mc2.getContext();
            this.si.processIntersections(ss1, start1, ss2, start2);
        }
    }
}

