/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.provider;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.opensaml.ExpiredAssertionException;
import org.opensaml.FatalProfileException;
import org.opensaml.ReplayCache;
import org.opensaml.ReplayedAssertionException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLBrowserProfile;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.UnsupportedProfileException;
import org.opensaml.XML;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParseException;
import org.opensaml.artifact.ArtifactParserException;
import org.opensaml.artifact.SAMLArtifact;
import org.w3c.dom.Element;

public class BrowserProfileProvider
implements SAMLBrowserProfile {
    private static Logger log = Logger.getLogger((String)BrowserProfileProvider.class.getName());
    private static int skew = 1000 * SAMLConfig.instance().getIntProperty("org.opensaml.clock-skew");

    public BrowserProfileProvider(Element element) {
    }

    public SAMLBrowserProfile.BrowserProfileRequest receive(HttpServletRequest httpServletRequest) throws UnsupportedProfileException {
        SAMLBrowserProfile.BrowserProfileRequest browserProfileRequest = new SAMLBrowserProfile.BrowserProfileRequest();
        browserProfileRequest.SAMLResponse = httpServletRequest.getParameter("SAMLResponse");
        if (browserProfileRequest.SAMLResponse == null) {
            browserProfileRequest.SAMLArt = httpServletRequest.getParameterValues("SAMLart");
            if (browserProfileRequest.SAMLArt == null || browserProfileRequest.SAMLArt.length == 0) {
                throw new UnsupportedProfileException("no SAMLResponse or SAMLart parameters supplied in HTTP request");
            }
        }
        browserProfileRequest.TARGET = httpServletRequest.getParameter("TARGET");
        return browserProfileRequest;
    }

    public SAMLBrowserProfile.BrowserProfileResponse receive(StringBuffer stringBuffer, SAMLBrowserProfile.BrowserProfileRequest browserProfileRequest, String string, ReplayCache replayCache, SAMLBrowserProfile.ArtifactMapper artifactMapper, int n) throws SAMLException {
        Object object;
        Object object2;
        boolean bl;
        SAMLAuthenticationStatement sAMLAuthenticationStatement;
        Object object3;
        SAMLResponse sAMLResponse;
        long l;
        block32: {
            l = System.currentTimeMillis();
            sAMLResponse = null;
            object3 = null;
            sAMLAuthenticationStatement = null;
            bl = true;
            if (browserProfileRequest.SAMLResponse != null) {
                sAMLResponse = new SAMLResponse(new ByteArrayInputStream(Base64.decodeBase64((byte[])browserProfileRequest.SAMLResponse.getBytes())), n);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("decoded SAML response:\n" + sAMLResponse.toString()));
                }
                try {
                    if (XML.isEmpty(string) || !XML.safeCompare(string, sAMLResponse.getRecipient())) {
                        throw new FatalProfileException("detected recipient mismatch in POST profile response");
                    }
                    if (sAMLResponse.getIssueInstant().getTime() < l - (long)(2 * skew)) {
                        throw new ExpiredAssertionException("detected expired POST profile response");
                    }
                    if (!sAMLResponse.isSigned()) {
                        throw new FatalProfileException("detected unsigned POST profile response");
                    }
                    break block32;
                }
                catch (SAMLException sAMLException) {
                    Iterator iterator;
                    if (stringBuffer != null && (iterator = sAMLResponse.getAssertions()).hasNext()) {
                        stringBuffer.append(((SAMLAssertion)iterator.next()).getIssuer());
                    }
                    throw sAMLException;
                }
            }
            if (browserProfileRequest.SAMLArt == null || browserProfileRequest.SAMLArt.length == 0) {
                throw new FatalProfileException("no SAMLResponse or SAMLart parameters supplied");
            }
            if (artifactMapper == null) {
                throw new FatalProfileException("support of artifact profile requires ArtifactMapper interface object");
            }
            Artifact[] artifactArray = new Artifact[browserProfileRequest.SAMLArt.length];
            for (int i = 0; i < browserProfileRequest.SAMLArt.length; ++i) {
                try {
                    log.debug((Object)("processing encoded artifact (" + browserProfileRequest.SAMLArt[i] + ")"));
                    if (replayCache != null) {
                        object2 = "A_" + browserProfileRequest.SAMLArt[i];
                        if (!replayCache.check((String)object2, new Date(System.currentTimeMillis() + (long)(2 * skew)))) {
                            throw new ReplayedAssertionException("rejecting replayed artifact (" + browserProfileRequest.SAMLArt[i] + ")");
                        }
                    } else {
                        log.warn((Object)"replay cache was not provided, this is a potential security risk!");
                    }
                    artifactArray[i] = SAMLArtifact.getTypeCode(browserProfileRequest.SAMLArt[i]).getParser().parse(browserProfileRequest.SAMLArt[i]);
                    continue;
                }
                catch (ArtifactParseException artifactParseException) {
                    log.error((Object)("invalid artifact (" + browserProfileRequest.SAMLArt[i] + ")"));
                    throw new FatalProfileException("unable to parse artifact");
                }
                catch (ArtifactParserException artifactParserException) {
                    log.error((Object)("unrecognized artifact type (" + browserProfileRequest.SAMLArt[i] + ")"));
                    throw new FatalProfileException("unable to build parser for received artifact, unknown type");
                }
            }
            object = new SAMLRequest(Arrays.asList(artifactArray));
            ((SAMLRequest)object).setMinorVersion(n);
            sAMLResponse = artifactMapper.resolve((SAMLRequest)object);
            bl = false;
        }
        try {
            boolean bl2 = false;
            object = sAMLResponse.getAssertions();
            while (object3 == null && object.hasNext()) {
                bl2 = false;
                object2 = (SAMLAssertion)object.next();
                Date date = ((SAMLAssertion)object2).getNotBefore();
                Date date2 = ((SAMLAssertion)object2).getNotOnOrAfter();
                if (date == null || date2 == null) {
                    log.debug((Object)"skipping assertion without time conditions...");
                    continue;
                }
                if (l + (long)skew < date.getTime()) {
                    bl2 = true;
                    log.debug((Object)"skipping assertion that's not yet valid...");
                    continue;
                }
                if (date2.getTime() <= l - (long)skew) {
                    bl2 = true;
                    log.debug((Object)"skipping expired assertion...");
                    continue;
                }
                Iterator iterator = ((SAMLAssertion)object2).getStatements();
                block9: while (sAMLAuthenticationStatement == null && iterator.hasNext()) {
                    SAMLStatement sAMLStatement = (SAMLStatement)iterator.next();
                    if (!(sAMLStatement instanceof SAMLAuthenticationStatement)) continue;
                    SAMLAuthenticationStatement sAMLAuthenticationStatement2 = (SAMLAuthenticationStatement)sAMLStatement;
                    SAMLSubject sAMLSubject = sAMLAuthenticationStatement2.getSubject();
                    Iterator iterator2 = sAMLSubject.getConfirmationMethods();
                    while (iterator2.hasNext()) {
                        String string2 = (String)iterator2.next();
                        if ((!bl || !string2.equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) && !string2.equals("urn:oasis:names:tc:SAML:1.0:cm:artifact") && !string2.equals("urn:oasis:names:tc:SAML:1.0:cm:artifact-01")) continue;
                        sAMLAuthenticationStatement = sAMLAuthenticationStatement2;
                        object3 = object2;
                        continue block9;
                    }
                }
            }
            if (sAMLAuthenticationStatement == null) {
                if (bl2 && sAMLResponse.getAssertions().hasNext()) {
                    throw new ExpiredAssertionException("unable to accept assertion because of clock skew");
                }
                throw new FatalProfileException("unable to locate a valid authentication statement");
            }
            if (bl) {
                if (replayCache != null) {
                    object = "P_" + ((SAMLAssertion)object3).getId();
                    if (!replayCache.check((String)object, ((SAMLAssertion)object3).getNotOnOrAfter())) {
                        throw new ReplayedAssertionException("rejecting replayed assertion ID (" + ((SAMLAssertion)object3).getId() + ")");
                    }
                } else {
                    log.warn((Object)"replay cache was not provided, this is a serious security risk!");
                }
            }
        }
        catch (SAMLException sAMLException) {
            if (stringBuffer != null && (object = sAMLResponse.getAssertions()).hasNext()) {
                stringBuffer.append(((SAMLAssertion)object.next()).getIssuer());
            }
            throw sAMLException;
        }
        SAMLBrowserProfile.BrowserProfileResponse browserProfileResponse = new SAMLBrowserProfile.BrowserProfileResponse();
        browserProfileResponse.response = sAMLResponse;
        browserProfileResponse.assertion = object3;
        browserProfileResponse.authnStatement = sAMLAuthenticationStatement;
        browserProfileResponse.TARGET = browserProfileRequest.TARGET;
        return browserProfileResponse;
    }
}

