/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.Map;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IHTMLHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.MetaParseState;

public class LinkParseState
extends MetaParseState {
    protected IHTMLHandler handler;

    public LinkParseState(IHTMLHandler handler) {
        super(handler);
        this.handler = handler;
    }

    @Override
    protected boolean noteNonscriptTag(String tagName, Map<String, String> attributes) throws ManifoldCFException {
        String srcValue;
        if (super.noteNonscriptTag(tagName, attributes)) {
            return true;
        }
        if (tagName.equals("a")) {
            String hrefValue = attributes.get("href");
            if (hrefValue != null && hrefValue.length() > 0) {
                this.handler.noteAHREF(hrefValue);
            }
        } else if (tagName.equals("link")) {
            String hrefValue = attributes.get("href");
            if (hrefValue != null && hrefValue.length() > 0) {
                this.handler.noteLINKHREF(hrefValue);
            }
        } else if (tagName.equals("img")) {
            String srcValue2 = attributes.get("src");
            if (srcValue2 != null && srcValue2.length() > 0) {
                this.handler.noteIMGSRC(srcValue2);
            }
        } else if (tagName.equals("frame") && (srcValue = attributes.get("src")) != null && srcValue.length() > 0) {
            this.handler.noteFRAMESRC(srcValue);
        }
        return false;
    }

    public void finishUp() throws ManifoldCFException {
        this.handler.finishUp();
        super.finishUp();
    }
}

