/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.noggit.JSONUtil;

public class RoutingRule
extends ZkNodeProps {
    private final List<DocRouter.Range> routeRanges;
    private final String routeRangesStr;
    private final String targetCollectionName;
    private final Long expireAt;

    public RoutingRule(String routeKey, Map<String, Object> propMap) {
        super(propMap);
        this.routeRangesStr = (String)propMap.get("routeRanges");
        String[] rangesArr = this.routeRangesStr.split(",");
        if (rangesArr != null && rangesArr.length > 0) {
            this.routeRanges = new ArrayList<DocRouter.Range>();
            for (String r : rangesArr) {
                this.routeRanges.add(DocRouter.DEFAULT.fromString(r));
            }
        } else {
            this.routeRanges = null;
        }
        this.targetCollectionName = (String)propMap.get("targetCollection");
        this.expireAt = Long.parseLong((String)propMap.get("expireAt"));
    }

    public List<DocRouter.Range> getRouteRanges() {
        return this.routeRanges;
    }

    public String getTargetCollectionName() {
        return this.targetCollectionName;
    }

    public Long getExpireAt() {
        return this.expireAt;
    }

    public String getRouteRangesStr() {
        return this.routeRangesStr;
    }

    @Override
    public String toString() {
        return JSONUtil.toJSON((Object)this.propMap, (int)-1);
    }
}

