/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine.tests;

import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.VariableReference;
import org.apache.manifoldcf.scriptengine.tests.ScriptEngineBase;
import org.junit.Assert;
import org.junit.Test;

public class CommandTest
extends ScriptEngineBase {
    @Test
    public void setCommand() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.executeStatements("set x = 1;"));
        VariableReference vr = this.evaluateExpression("x");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)1L, (long)vr.resolve().getIntValue());
    }

    @Test
    public void ifCommand() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.executeStatements("if 1==1 then set y = 1; else set y = 2; ;"));
        VariableReference vr = this.evaluateExpression("y");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)1L, (long)vr.resolve().getIntValue());
        Assert.assertEquals((Object)false, (Object)this.executeStatements("if 1==0 then set y = 1; else set y = 2; ;"));
        vr = this.evaluateExpression("y");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)2L, (long)vr.resolve().getIntValue());
    }

    @Test
    public void whileCommand() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.executeStatements("set counter = 10; while counter > 0 do set counter = counter - 1; ;"));
        VariableReference vr = this.evaluateExpression("counter");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)0L, (long)vr.resolve().getIntValue());
        Assert.assertEquals((Object)false, (Object)this.executeStatements("set flag = null; while ! isnull foo do set flag = 1; ;"));
        vr = this.evaluateExpression("flag");
        Assert.assertNotNull((Object)vr);
        Assert.assertNull((Object)vr.resolve());
    }

    @Test
    public void breakCommand() throws Exception {
        Assert.assertEquals((Object)true, (Object)this.executeStatements("set x = null; break; set x = 1;"));
        VariableReference vr = this.evaluateExpression("x");
        Assert.assertNotNull((Object)vr);
        Assert.assertNull((Object)vr.resolve());
    }

    @Test
    public void waitCommand() throws Exception {
        long now = System.currentTimeMillis();
        Assert.assertEquals((Object)false, (Object)this.executeStatements("wait 1000;"));
        Assert.assertEquals((Object)true, (Object)(now + 1000L <= System.currentTimeMillis() ? 1 : 0));
    }

    @Test
    public void errorCommand() throws Exception {
        boolean sawException = false;
        try {
            this.executeStatements("error '123456';");
        }
        catch (ScriptException e) {
            if (e.getMessage().indexOf("123456") != -1) {
                sawException = true;
            }
            throw e;
        }
        Assert.assertEquals((Object)true, (Object)sawException);
    }

    @Test
    public void printCommand() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.executeStatements("print 'hello';"));
    }
}

