/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities;

import org.apache.manifoldcf.authorities.BaseAuthoritiesInitializationCommand;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorManager;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class SynchronizeAuthorities
extends BaseAuthoritiesInitializationCommand {
    public static final String _rcsid = "@(#)$Id: SynchronizeAuthorities.java 988245 2010-08-23 18:39:35Z kwright $";

    @Override
    protected void doExecute(IAuthorityConnectorManager mgr) throws ManifoldCFException {
        IResultSet classNames = mgr.getConnectors();
        int i = 0;
        while (i < classNames.getRowCount()) {
            IResultRow row = classNames.getRow(i++);
            String classname = (String)row.getValue("classname");
            try {
                AuthorityConnectorFactory.getConnectorNoCheck(classname);
            }
            catch (ManifoldCFException e) {
                mgr.removeConnector(classname);
            }
        }
        Logging.root.info((Object)"Successfully synchronized all authorities");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.err.println("Usage: SynchronizeAuthorities");
            System.exit(1);
        }
        try {
            SynchronizeAuthorities synchronizeAuthorities = new SynchronizeAuthorities();
            synchronizeAuthorities.execute();
            System.err.println("Successfully synchronized all authorities");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

