/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.jhighlight.tools;

import com.uwyn.jhighlight.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public abstract class StringUtils {
    private static final Char2ObjectOpenHashMap<String> mHtmlEncodeMap = new Char2ObjectOpenHashMap();

    private StringUtils() {
    }

    public static String encodeHtml(String source) {
        return StringUtils.encode(source, mHtmlEncodeMap);
    }

    private static String encode(String source, Char2ObjectOpenHashMap<String> encodingTable) {
        if (null == source) {
            return null;
        }
        if (null == encodingTable) {
            return source;
        }
        StringBuffer encoded_string = null;
        char[] string_to_encode_array = source.toCharArray();
        int last_match = -1;
        int difference = 0;
        for (int i = 0; i < string_to_encode_array.length; ++i) {
            char char_to_encode = string_to_encode_array[i];
            if (!encodingTable.containsKey(char_to_encode)) continue;
            if (null == encoded_string) {
                encoded_string = new StringBuffer(source.length());
            }
            if ((difference = i - (last_match + 1)) > 0) {
                encoded_string.append(string_to_encode_array, last_match + 1, difference);
            }
            encoded_string.append(encodingTable.get(char_to_encode));
            last_match = i;
        }
        if (null == encoded_string) {
            return source;
        }
        difference = string_to_encode_array.length - (last_match + 1);
        if (difference > 0) {
            encoded_string.append(string_to_encode_array, last_match + 1, difference);
        }
        return encoded_string.toString();
    }

    public static boolean filter(String name, Pattern included, Pattern excluded) {
        Pattern[] included_array = null;
        if (included != null) {
            included_array = new Pattern[]{included};
        }
        Pattern[] excluded_array = null;
        if (excluded != null) {
            excluded_array = new Pattern[]{excluded};
        }
        return StringUtils.filter(name, included_array, excluded_array);
    }

    public static boolean filter(String name, Pattern[] included, Pattern[] excluded) {
        Pattern pattern;
        int i;
        if (null == name) {
            return false;
        }
        boolean accepted = false;
        if (null == included) {
            accepted = true;
        } else {
            for (i = 0; i < included.length; ++i) {
                pattern = included[i];
                if (pattern == null || !pattern.matcher(name).matches()) continue;
                accepted = true;
                break;
            }
        }
        if (accepted && excluded != null) {
            for (i = 0; i < excluded.length; ++i) {
                pattern = excluded[i];
                if (pattern == null || !pattern.matcher(name).matches()) continue;
                accepted = false;
                break;
            }
        }
        return accepted;
    }

    public static ArrayList split(String source, String seperator) {
        return StringUtils.split(source, seperator, true);
    }

    public static ArrayList split(String source, String seperator, boolean matchCase) {
        ArrayList<String> substrings = new ArrayList<String>();
        if (null == source) {
            return substrings;
        }
        if (null == seperator) {
            substrings.add(source);
            return substrings;
        }
        int current_index = 0;
        int delimiter_index = 0;
        String element = null;
        String source_lookup_reference = null;
        if (!matchCase) {
            source_lookup_reference = source.toLowerCase();
            seperator = seperator.toLowerCase();
        } else {
            source_lookup_reference = source;
        }
        while (current_index <= source_lookup_reference.length()) {
            delimiter_index = source_lookup_reference.indexOf(seperator, current_index);
            if (-1 == delimiter_index) {
                element = new String(source.substring(current_index, source.length()));
                substrings.add(element);
                current_index = source.length() + 1;
                continue;
            }
            element = new String(source.substring(current_index, delimiter_index));
            substrings.add(element);
            current_index = delimiter_index + seperator.length();
        }
        return substrings;
    }

    public static String replace(String source, String stringToReplace, String replacementString) {
        return StringUtils.replace(source, stringToReplace, replacementString, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replace(String source, String stringToReplace, String replacementString, boolean matchCase) {
        StringBuffer new_string;
        if (null == source) {
            return null;
        }
        if (null == stringToReplace) {
            return source;
        }
        if (null == replacementString) {
            return source;
        }
        Iterator string_parts = StringUtils.split(source, stringToReplace, matchCase).iterator();
        StringBuffer stringBuffer = new_string = new StringBuffer();
        synchronized (stringBuffer) {
            while (string_parts.hasNext()) {
                String string_part = (String)string_parts.next();
                new_string.append(string_part);
                if (!string_parts.hasNext()) continue;
                new_string.append(replacementString);
            }
            return new_string.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String repeat(String source, int count) {
        StringBuffer new_string;
        if (null == source) {
            return null;
        }
        StringBuffer stringBuffer = new_string = new StringBuffer();
        synchronized (stringBuffer) {
            while (count > 0) {
                new_string.append(source);
                --count;
            }
            return new_string.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertTabsToSpaces(String line, int tabWidth) {
        StringBuffer result;
        StringBuffer stringBuffer = result = new StringBuffer();
        synchronized (stringBuffer) {
            int tab_index = -1;
            int last_tab_index = 0;
            int added_chars = 0;
            while ((tab_index = line.indexOf("\t", last_tab_index)) != -1) {
                int tab_size = tabWidth - (tab_index + added_chars) % tabWidth;
                if (0 == tab_size) {
                    tab_size = tabWidth;
                }
                added_chars += tab_size - 1;
                result.append(line.substring(last_tab_index, tab_index));
                result.append(StringUtils.repeat(" ", tab_size));
                last_tab_index = tab_index + 1;
            }
            if (0 == last_tab_index) {
                return line;
            }
            result.append(line.substring(last_tab_index));
        }
        return result.toString();
    }

    static {
        mHtmlEncodeMap.put('&', "&amp;");
        mHtmlEncodeMap.put('<', "&lt;");
        mHtmlEncodeMap.put('>', "&gt;");
        mHtmlEncodeMap.put('\"', "&quot;");
        mHtmlEncodeMap.put('\u0152', "&OElig;");
        mHtmlEncodeMap.put('\u0153', "&oelig;");
        mHtmlEncodeMap.put('\u0160', "&Scaron;");
        mHtmlEncodeMap.put('\u0161', "&scaron;");
        mHtmlEncodeMap.put('\u0178', "&Yuml;");
        mHtmlEncodeMap.put('\u02c6', "&circ;");
        mHtmlEncodeMap.put('\u02dc', "&tilde;");
        mHtmlEncodeMap.put('\u2002', "&ensp;");
        mHtmlEncodeMap.put('\u2003', "&emsp;");
        mHtmlEncodeMap.put('\u2009', "&thinsp;");
        mHtmlEncodeMap.put('\u200c', "&zwnj;");
        mHtmlEncodeMap.put('\u200d', "&zwj;");
        mHtmlEncodeMap.put('\u200e', "&lrm;");
        mHtmlEncodeMap.put('\u200f', "&rlm;");
        mHtmlEncodeMap.put('\u2013', "&ndash;");
        mHtmlEncodeMap.put('\u2014', "&mdash;");
        mHtmlEncodeMap.put('\u2018', "&lsquo;");
        mHtmlEncodeMap.put('\u2019', "&rsquo;");
        mHtmlEncodeMap.put('\u201a', "&sbquo;");
        mHtmlEncodeMap.put('\u201c', "&ldquo;");
        mHtmlEncodeMap.put('\u201d', "&rdquo;");
        mHtmlEncodeMap.put('\u201e', "&bdquo;");
        mHtmlEncodeMap.put('\u2020', "&dagger;");
        mHtmlEncodeMap.put('\u2021', "&Dagger;");
        mHtmlEncodeMap.put('\u2030', "&permil;");
        mHtmlEncodeMap.put('\u2039', "&lsaquo;");
        mHtmlEncodeMap.put('\u203a', "&rsaquo;");
        mHtmlEncodeMap.put('\u20ac', "&euro;");
        mHtmlEncodeMap.put('\u00a0', "&nbsp;");
        mHtmlEncodeMap.put('\u00a1', "&iexcl;");
        mHtmlEncodeMap.put('\u00a2', "&cent;");
        mHtmlEncodeMap.put('\u00a3', "&pound;");
        mHtmlEncodeMap.put('\u00a4', "&curren;");
        mHtmlEncodeMap.put('\u00a5', "&yen;");
        mHtmlEncodeMap.put('\u00a6', "&brvbar;");
        mHtmlEncodeMap.put('\u00a7', "&sect;");
        mHtmlEncodeMap.put('\u00a8', "&uml;");
        mHtmlEncodeMap.put('\u00a9', "&copy;");
        mHtmlEncodeMap.put('\u00aa', "&ordf;");
        mHtmlEncodeMap.put('\u00ab', "&laquo;");
        mHtmlEncodeMap.put('\u00ac', "&not;");
        mHtmlEncodeMap.put('\u00ad', "&shy;");
        mHtmlEncodeMap.put('\u00ae', "&reg;");
        mHtmlEncodeMap.put('\u00af', "&macr;");
        mHtmlEncodeMap.put('\u00b0', "&deg;");
        mHtmlEncodeMap.put('\u00b1', "&plusmn;");
        mHtmlEncodeMap.put('\u00b2', "&sup2;");
        mHtmlEncodeMap.put('\u00b3', "&sup3;");
        mHtmlEncodeMap.put('\u00b4', "&acute;");
        mHtmlEncodeMap.put('\u00b5', "&micro;");
        mHtmlEncodeMap.put('\u00b6', "&para;");
        mHtmlEncodeMap.put('\u00b7', "&middot;");
        mHtmlEncodeMap.put('\u00b8', "&cedil;");
        mHtmlEncodeMap.put('\u00b9', "&sup1;");
        mHtmlEncodeMap.put('\u00ba', "&ordm;");
        mHtmlEncodeMap.put('\u00bb', "&raquo;");
        mHtmlEncodeMap.put('\u00bc', "&frac14;");
        mHtmlEncodeMap.put('\u00bd', "&frac12;");
        mHtmlEncodeMap.put('\u00be', "&frac34;");
        mHtmlEncodeMap.put('\u00bf', "&iquest;");
        mHtmlEncodeMap.put('\u00c0', "&Agrave;");
        mHtmlEncodeMap.put('\u00c1', "&Aacute;");
        mHtmlEncodeMap.put('\u00c2', "&Acirc;");
        mHtmlEncodeMap.put('\u00c3', "&Atilde;");
        mHtmlEncodeMap.put('\u00c4', "&Auml;");
        mHtmlEncodeMap.put('\u00c5', "&Aring;");
        mHtmlEncodeMap.put('\u00c6', "&AElig;");
        mHtmlEncodeMap.put('\u00c7', "&Ccedil;");
        mHtmlEncodeMap.put('\u00c8', "&Egrave;");
        mHtmlEncodeMap.put('\u00c9', "&Eacute;");
        mHtmlEncodeMap.put('\u00ca', "&Ecirc;");
        mHtmlEncodeMap.put('\u00cb', "&Euml;");
        mHtmlEncodeMap.put('\u00cc', "&Igrave;");
        mHtmlEncodeMap.put('\u00cd', "&Iacute;");
        mHtmlEncodeMap.put('\u00ce', "&Icirc;");
        mHtmlEncodeMap.put('\u00cf', "&Iuml;");
        mHtmlEncodeMap.put('\u00d0', "&ETH;");
        mHtmlEncodeMap.put('\u00d1', "&Ntilde;");
        mHtmlEncodeMap.put('\u00d2', "&Ograve;");
        mHtmlEncodeMap.put('\u00d3', "&Oacute;");
        mHtmlEncodeMap.put('\u00d4', "&Ocirc;");
        mHtmlEncodeMap.put('\u00d5', "&Otilde;");
        mHtmlEncodeMap.put('\u00d6', "&Ouml;");
        mHtmlEncodeMap.put('\u00d7', "&times;");
        mHtmlEncodeMap.put('\u00d8', "&Oslash;");
        mHtmlEncodeMap.put('\u00d9', "&Ugrave;");
        mHtmlEncodeMap.put('\u00da', "&Uacute;");
        mHtmlEncodeMap.put('\u00db', "&Ucirc;");
        mHtmlEncodeMap.put('\u00dc', "&Uuml;");
        mHtmlEncodeMap.put('\u00dd', "&Yacute;");
        mHtmlEncodeMap.put('\u00de', "&THORN;");
        mHtmlEncodeMap.put('\u00df', "&szlig;");
        mHtmlEncodeMap.put('\u00e0', "&agrave;");
        mHtmlEncodeMap.put('\u00e1', "&aacute;");
        mHtmlEncodeMap.put('\u00e2', "&acirc;");
        mHtmlEncodeMap.put('\u00e3', "&atilde;");
        mHtmlEncodeMap.put('\u00e4', "&auml;");
        mHtmlEncodeMap.put('\u00e5', "&aring;");
        mHtmlEncodeMap.put('\u00e6', "&aelig;");
        mHtmlEncodeMap.put('\u00e7', "&ccedil;");
        mHtmlEncodeMap.put('\u00e8', "&egrave;");
        mHtmlEncodeMap.put('\u00e9', "&eacute;");
        mHtmlEncodeMap.put('\u00ea', "&ecirc;");
        mHtmlEncodeMap.put('\u00eb', "&euml;");
        mHtmlEncodeMap.put('\u00ec', "&igrave;");
        mHtmlEncodeMap.put('\u00ed', "&iacute;");
        mHtmlEncodeMap.put('\u00ee', "&icirc;");
        mHtmlEncodeMap.put('\u00ef', "&iuml;");
        mHtmlEncodeMap.put('\u00f0', "&eth;");
        mHtmlEncodeMap.put('\u00f1', "&ntilde;");
        mHtmlEncodeMap.put('\u00f2', "&ograve;");
        mHtmlEncodeMap.put('\u00f3', "&oacute;");
        mHtmlEncodeMap.put('\u00f4', "&ocirc;");
        mHtmlEncodeMap.put('\u00f5', "&otilde;");
        mHtmlEncodeMap.put('\u00f6', "&ouml;");
        mHtmlEncodeMap.put('\u00f7', "&divide;");
        mHtmlEncodeMap.put('\u00f8', "&oslash;");
        mHtmlEncodeMap.put('\u00f9', "&ugrave;");
        mHtmlEncodeMap.put('\u00fa', "&uacute;");
        mHtmlEncodeMap.put('\u00fb', "&ucirc;");
        mHtmlEncodeMap.put('\u00fc', "&uuml;");
        mHtmlEncodeMap.put('\u00fd', "&yacute;");
        mHtmlEncodeMap.put('\u00fe', "&thorn;");
        mHtmlEncodeMap.put('\u00ff', "&yuml;");
        mHtmlEncodeMap.put('\u0192', "&fnof;");
        mHtmlEncodeMap.put('\u0391', "&Alpha;");
        mHtmlEncodeMap.put('\u0392', "&Beta;");
        mHtmlEncodeMap.put('\u0393', "&Gamma;");
        mHtmlEncodeMap.put('\u0394', "&Delta;");
        mHtmlEncodeMap.put('\u0395', "&Epsilon;");
        mHtmlEncodeMap.put('\u0396', "&Zeta;");
        mHtmlEncodeMap.put('\u0397', "&Eta;");
        mHtmlEncodeMap.put('\u0398', "&Theta;");
        mHtmlEncodeMap.put('\u0399', "&Iota;");
        mHtmlEncodeMap.put('\u039a', "&Kappa;");
        mHtmlEncodeMap.put('\u039b', "&Lambda;");
        mHtmlEncodeMap.put('\u039c', "&Mu;");
        mHtmlEncodeMap.put('\u039d', "&Nu;");
        mHtmlEncodeMap.put('\u039e', "&Xi;");
        mHtmlEncodeMap.put('\u039f', "&Omicron;");
        mHtmlEncodeMap.put('\u03a0', "&Pi;");
        mHtmlEncodeMap.put('\u03a1', "&Rho;");
        mHtmlEncodeMap.put('\u03a3', "&Sigma;");
        mHtmlEncodeMap.put('\u03a4', "&Tau;");
        mHtmlEncodeMap.put('\u03a5', "&Upsilon;");
        mHtmlEncodeMap.put('\u03a6', "&Phi;");
        mHtmlEncodeMap.put('\u03a7', "&Chi;");
        mHtmlEncodeMap.put('\u03a8', "&Psi;");
        mHtmlEncodeMap.put('\u03a9', "&Omega;");
        mHtmlEncodeMap.put('\u03b1', "&alpha;");
        mHtmlEncodeMap.put('\u03b2', "&beta;");
        mHtmlEncodeMap.put('\u03b3', "&gamma;");
        mHtmlEncodeMap.put('\u03b4', "&delta;");
        mHtmlEncodeMap.put('\u03b5', "&epsilon;");
        mHtmlEncodeMap.put('\u03b6', "&zeta;");
        mHtmlEncodeMap.put('\u03b7', "&eta;");
        mHtmlEncodeMap.put('\u03b8', "&theta;");
        mHtmlEncodeMap.put('\u03b9', "&iota;");
        mHtmlEncodeMap.put('\u03ba', "&kappa;");
        mHtmlEncodeMap.put('\u03bb', "&lambda;");
        mHtmlEncodeMap.put('\u03bc', "&mu;");
        mHtmlEncodeMap.put('\u03bd', "&nu;");
        mHtmlEncodeMap.put('\u03be', "&xi;");
        mHtmlEncodeMap.put('\u03bf', "&omicron;");
        mHtmlEncodeMap.put('\u03c0', "&pi;");
        mHtmlEncodeMap.put('\u03c1', "&rho;");
        mHtmlEncodeMap.put('\u03c2', "&sigmaf;");
        mHtmlEncodeMap.put('\u03c3', "&sigma;");
        mHtmlEncodeMap.put('\u03c4', "&tau;");
        mHtmlEncodeMap.put('\u03c5', "&upsilon;");
        mHtmlEncodeMap.put('\u03c6', "&phi;");
        mHtmlEncodeMap.put('\u03c7', "&chi;");
        mHtmlEncodeMap.put('\u03c8', "&psi;");
        mHtmlEncodeMap.put('\u03c9', "&omega;");
        mHtmlEncodeMap.put('\u03d1', "&thetasym;");
        mHtmlEncodeMap.put('\u03d2', "&upsih;");
        mHtmlEncodeMap.put('\u03d6', "&piv;");
        mHtmlEncodeMap.put('\u2022', "&bull;");
        mHtmlEncodeMap.put('\u2026', "&hellip;");
        mHtmlEncodeMap.put('\u2032', "&prime;");
        mHtmlEncodeMap.put('\u2033', "&Prime;");
        mHtmlEncodeMap.put('\u203e', "&oline;");
        mHtmlEncodeMap.put('\u2044', "&frasl;");
        mHtmlEncodeMap.put('\u2118', "&weierp;");
        mHtmlEncodeMap.put('\u2111', "&image;");
        mHtmlEncodeMap.put('\u211c', "&real;");
        mHtmlEncodeMap.put('\u2122', "&trade;");
        mHtmlEncodeMap.put('\u2135', "&alefsym;");
        mHtmlEncodeMap.put('\u2190', "&larr;");
        mHtmlEncodeMap.put('\u2191', "&uarr;");
        mHtmlEncodeMap.put('\u2192', "&rarr;");
        mHtmlEncodeMap.put('\u2193', "&darr;");
        mHtmlEncodeMap.put('\u2194', "&harr;");
        mHtmlEncodeMap.put('\u21b5', "&crarr;");
        mHtmlEncodeMap.put('\u21d0', "&lArr;");
        mHtmlEncodeMap.put('\u21d1', "&uArr;");
        mHtmlEncodeMap.put('\u21d2', "&rArr;");
        mHtmlEncodeMap.put('\u21d3', "&dArr;");
        mHtmlEncodeMap.put('\u21d4', "&hArr;");
        mHtmlEncodeMap.put('\u2200', "&forall;");
        mHtmlEncodeMap.put('\u2202', "&part;");
        mHtmlEncodeMap.put('\u2203', "&exist;");
        mHtmlEncodeMap.put('\u2205', "&empty;");
        mHtmlEncodeMap.put('\u2207', "&nabla;");
        mHtmlEncodeMap.put('\u2208', "&isin;");
        mHtmlEncodeMap.put('\u2209', "&notin;");
        mHtmlEncodeMap.put('\u220b', "&ni;");
        mHtmlEncodeMap.put('\u220f', "&prod;");
        mHtmlEncodeMap.put('\u2211', "&sum;");
        mHtmlEncodeMap.put('\u2212', "&minus;");
        mHtmlEncodeMap.put('\u2217', "&lowast;");
        mHtmlEncodeMap.put('\u221a', "&radic;");
        mHtmlEncodeMap.put('\u221d', "&prop;");
        mHtmlEncodeMap.put('\u221e', "&infin;");
        mHtmlEncodeMap.put('\u2220', "&ang;");
        mHtmlEncodeMap.put('\u2227', "&and;");
        mHtmlEncodeMap.put('\u2228', "&or;");
        mHtmlEncodeMap.put('\u2229', "&cap;");
        mHtmlEncodeMap.put('\u222a', "&cup;");
        mHtmlEncodeMap.put('\u222b', "&int;");
        mHtmlEncodeMap.put('\u2234', "&there4;");
        mHtmlEncodeMap.put('\u223c', "&sim;");
        mHtmlEncodeMap.put('\u2245', "&cong;");
        mHtmlEncodeMap.put('\u2248', "&asymp;");
        mHtmlEncodeMap.put('\u2260', "&ne;");
        mHtmlEncodeMap.put('\u2261', "&equiv;");
        mHtmlEncodeMap.put('\u2264', "&le;");
        mHtmlEncodeMap.put('\u2265', "&ge;");
        mHtmlEncodeMap.put('\u2282', "&sub;");
        mHtmlEncodeMap.put('\u2283', "&sup;");
        mHtmlEncodeMap.put('\u2284', "&nsub;");
        mHtmlEncodeMap.put('\u2286', "&sube;");
        mHtmlEncodeMap.put('\u2287', "&supe;");
        mHtmlEncodeMap.put('\u2295', "&oplus;");
        mHtmlEncodeMap.put('\u2297', "&otimes;");
        mHtmlEncodeMap.put('\u22a5', "&perp;");
        mHtmlEncodeMap.put('\u22c5', "&sdot;");
        mHtmlEncodeMap.put('\u2308', "&lceil;");
        mHtmlEncodeMap.put('\u2309', "&rceil;");
        mHtmlEncodeMap.put('\u230a', "&lfloor;");
        mHtmlEncodeMap.put('\u230b', "&rfloor;");
        mHtmlEncodeMap.put('\u2329', "&lang;");
        mHtmlEncodeMap.put('\u232a', "&rang;");
        mHtmlEncodeMap.put('\u25ca', "&loz;");
        mHtmlEncodeMap.put('\u2660', "&spades;");
        mHtmlEncodeMap.put('\u2663', "&clubs;");
        mHtmlEncodeMap.put('\u2665', "&hearts;");
        mHtmlEncodeMap.put('\u2666', "&diams;");
    }
}

