/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.jira;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.core.common.InterruptibleSocketFactory;
import org.apache.manifoldcf.core.common.XThreadStringBuffer;
import org.apache.manifoldcf.core.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.connectors.jira.JiraIssue;
import org.apache.manifoldcf.crawler.connectors.jira.JiraJSONResponse;
import org.apache.manifoldcf.crawler.connectors.jira.JiraQueryResults;
import org.apache.manifoldcf.crawler.connectors.jira.JiraUserQueryResults;
import org.apache.manifoldcf.crawler.connectors.jira.ResponseException;
import org.json.simple.JSONValue;

public class JiraSession {
    private final HttpHost host;
    private final String path;
    private final String clientId;
    private final String clientSecret;
    private HttpClientConnectionManager connectionManager;
    private HttpClient httpClient;
    private static String currentHost = null;

    public JiraSession(String clientId, String clientSecret, String protocol, String host, int port, String path, String proxyHost, int proxyPort, String proxyDomain, String proxyUsername, String proxyPassword) throws ManifoldCFException {
        this.host = new HttpHost(host, port, protocol);
        this.path = path;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        int socketTimeout = 900000;
        int connectionTimeout = 60000;
        SSLSocketFactory httpsSocketFactory = KeystoreManagerFactory.getTrustingSecureSocketFactory();
        SSLConnectionSocketFactory myFactory = new SSLConnectionSocketFactory((SSLSocketFactory)new InterruptibleSocketFactory(httpsSocketFactory, (long)connectionTimeout), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
        poolingConnectionManager.setDefaultMaxPerRoute(1);
        poolingConnectionManager.setValidateAfterInactivity(60000);
        poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
        this.connectionManager = poolingConnectionManager;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (clientId != null) {
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(clientId, clientSecret));
        }
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(true).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
        if (proxyHost != null && proxyHost.length() > 0) {
            if (proxyUsername != null && proxyUsername.length() > 0) {
                if (proxyPassword == null) {
                    proxyPassword = "";
                }
                if (proxyDomain == null) {
                    proxyDomain = "";
                }
                credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, currentHost, proxyDomain));
            }
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            requestBuilder.setProxy(proxy);
        }
        this.httpClient = HttpClients.custom().setConnectionManager(this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setRequestExecutor(new HttpRequestExecutor(socketTimeout)).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).build();
    }

    public void close() {
        this.httpClient = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object convertToJSON(HttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try (InputStream is = entity.getContent();){
                InputStreamReader r = new InputStreamReader(is, JiraSession.getCharSet(entity));
                Object object = JSONValue.parse((Reader)r);
                return object;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertToString(HttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try (InputStream is = entity.getContent();){
                char[] buffer = new char[65536];
                InputStreamReader r = new InputStreamReader(is, JiraSession.getCharSet(entity));
                StringWriter w = new StringWriter();
                try {
                    int amt;
                    while ((amt = r.read(buffer)) != -1) {
                        ((Writer)w).write(buffer, 0, amt);
                    }
                }
                finally {
                    ((Writer)w).flush();
                }
                String string = ((Object)w).toString();
                return string;
            }
        }
        return "";
    }

    private static Charset getCharSet(HttpEntity entity) {
        Charset charSet;
        try {
            ContentType ct = ContentType.get((HttpEntity)entity);
            charSet = ct == null ? StandardCharsets.UTF_8 : ct.getCharset();
        }
        catch (ParseException e) {
            charSet = StandardCharsets.UTF_8;
        }
        return charSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRest(String rightside, JiraJSONResponse response) throws IOException, ResponseException {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.host, (AuthScheme)basicAuth);
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)authCache);
        HttpGet method = new HttpGet(this.host.toURI() + this.path + rightside);
        method.addHeader("Accept", "application/json");
        try {
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)method, (HttpContext)localContext);
            int resultCode = httpResponse.getStatusLine().getStatusCode();
            if (resultCode != 200) {
                throw new IOException("Unexpected result code " + resultCode + ": " + JiraSession.convertToString(httpResponse));
            }
            Object jo = JiraSession.convertToJSON(httpResponse);
            response.acceptJSONObject(jo);
        }
        finally {
            method.abort();
        }
    }

    public Map<String, String> getRepositoryInfo() throws IOException, ResponseException {
        HashMap<String, String> statistics = new HashMap<String, String>();
        JiraQueryResults qr = new JiraQueryResults();
        this.getRest("search?maxResults=1&jql=", qr);
        statistics.put("Total Issues", qr.getTotal().toString());
        return statistics;
    }

    public void getSeeds(XThreadStringBuffer idBuffer, String jiraDriveQuery) throws IOException, ResponseException, InterruptedException, ManifoldCFException {
        long startAt = 0L;
        long setSize = 800L;
        long totalAmt = 0L;
        do {
            JiraQueryResults qr = new JiraQueryResults();
            this.getRest("search?maxResults=" + setSize + "&startAt=" + startAt + "&jql=" + URLEncoder.encode((String)jiraDriveQuery), qr);
            Long total = qr.getTotal();
            if (total == null) {
                return;
            }
            totalAmt = total;
            qr.pushIds(idBuffer);
        } while ((startAt += setSize) < totalAmt);
    }

    public List<String> getUsers(String issueKey) throws IOException, ResponseException, ManifoldCFException {
        ArrayList<String> rval = new ArrayList<String>();
        long startAt = 0L;
        long setSize = 800L;
        do {
            JiraUserQueryResults qr = new JiraUserQueryResults();
            this.getRest("user/viewissue/search?username=&issueKey=" + URLEncoder.encode((String)issueKey) + "&maxResults=" + setSize + "&startAt=" + startAt, qr);
            qr.getNames(rval);
        } while ((long)rval.size() >= (startAt += setSize));
        return rval;
    }

    public JiraIssue getIssue(String issueKey) throws IOException, ResponseException, ManifoldCFException {
        JiraIssue ji = new JiraIssue();
        this.getRest("issue/" + URLEncoder.encode((String)issueKey), ji);
        return ji;
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            currentHost = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

