/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;

public class SortedConcurrentMappingSet
implements Iterable<StubMapping> {
    private AtomicLong insertionCount = new AtomicLong();
    private ConcurrentSkipListSet<StubMapping> mappingSet = new ConcurrentSkipListSet<StubMapping>(this.sortedByPriorityThenReverseInsertionOrder());

    private Comparator<StubMapping> sortedByPriorityThenReverseInsertionOrder() {
        return new Comparator<StubMapping>(){

            @Override
            public int compare(StubMapping one, StubMapping two) {
                int priorityComparison = one.comparePriorityWith(two);
                if (priorityComparison != 0) {
                    return priorityComparison;
                }
                return two.getInsertionIndex() > one.getInsertionIndex() ? 1 : -1;
            }
        };
    }

    @Override
    public Iterator<StubMapping> iterator() {
        return this.mappingSet.iterator();
    }

    public void add(StubMapping mapping) {
        mapping.setInsertionIndex(this.insertionCount.getAndIncrement());
        this.mappingSet.add(mapping);
    }

    public void clear() {
        this.mappingSet.clear();
    }

    public String toString() {
        return this.mappingSet.toString();
    }
}

