/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.util.Arrays;
import org.apache.poi.ddf.EscherProperties;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class EscherComplexProperty
extends EscherProperty {
    protected byte[] _complexData;

    public EscherComplexProperty(short id, byte[] complexData) {
        super(id);
        this._complexData = complexData;
    }

    public EscherComplexProperty(short propertyNumber, boolean isBlipId, byte[] complexData) {
        super(propertyNumber, true, isBlipId);
        this._complexData = complexData;
    }

    @Override
    public int serializeSimplePart(byte[] data, int pos) {
        LittleEndian.putShort(data, pos, this.getId());
        LittleEndian.putInt(data, pos + 2, this._complexData.length);
        return 6;
    }

    @Override
    public int serializeComplexPart(byte[] data, int pos) {
        System.arraycopy(this._complexData, 0, data, pos, this._complexData.length);
        return this._complexData.length;
    }

    public byte[] getComplexData() {
        return this._complexData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EscherComplexProperty)) {
            return false;
        }
        EscherComplexProperty escherComplexProperty = (EscherComplexProperty)o;
        return Arrays.equals(this._complexData, escherComplexProperty._complexData);
    }

    @Override
    public int getPropertySize() {
        return 6 + this._complexData.length;
    }

    public int hashCode() {
        return this.getId() * 11;
    }

    public String toString() {
        String dataStr = HexDump.toHex(this._complexData, 32);
        return "propNum: " + this.getPropertyNumber() + ", propName: " + EscherProperties.getPropertyName(this.getPropertyNumber()) + ", complex: " + this.isComplex() + ", blipId: " + this.isBlipId() + ", data: " + System.getProperty("line.separator") + dataStr;
    }

    @Override
    public String toXml(String tab) {
        String dataStr = HexDump.toHex(this._complexData, 32);
        StringBuilder builder = new StringBuilder();
        builder.append(tab).append("<").append(this.getClass().getSimpleName()).append(" id=\"0x").append(HexDump.toHex(this.getId())).append("\" name=\"").append(this.getName()).append("\" blipId=\"").append(this.isBlipId()).append("\">\n");
        builder.append(tab).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return builder.toString();
    }
}

