/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;

class FloatStreamInFloatValueOutFunction
extends FloatValue.AbstractFloatValue
implements FloatConsumer {
    private final FloatValueStream param;
    private final LambdaFunction.TwoFloatInFloatOutLambda lambda;
    private final String name;
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;
    private float value;

    public FloatStreamInFloatValueOutFunction(String name, LambdaFunction.TwoFloatInFloatOutLambda lambda, FloatValueStream param) {
        this.name = name;
        this.lambda = lambda;
        this.param = param;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
    }

    @Override
    public float getFloat() {
        this.exists = false;
        this.param.streamFloats(this);
        return this.value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void accept(float paramValue) {
        if (!this.exists) {
            this.exists = true;
            this.value = paramValue;
        } else {
            this.value = this.lambda.apply(this.value, paramValue);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

