/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.solr.search.EarlyTerminatingCollectorException;

public class EarlyTerminatingCollector
extends FilterCollector {
    private final int maxDocsToCollect;
    private int numCollected = 0;
    private int prevReaderCumulativeSize = 0;
    private int currentReaderSize = 0;

    public EarlyTerminatingCollector(Collector delegate, int maxDocsToCollect) {
        super(delegate);
        assert (0 < maxDocsToCollect);
        assert (null != delegate);
        this.maxDocsToCollect = maxDocsToCollect;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        this.prevReaderCumulativeSize += this.currentReaderSize;
        this.currentReaderSize = context.reader().maxDoc() - 1;
        return new FilterLeafCollector(super.getLeafCollector(context)){

            public void collect(int doc) throws IOException {
                super.collect(doc);
                EarlyTerminatingCollector.this.numCollected++;
                if (EarlyTerminatingCollector.this.maxDocsToCollect <= EarlyTerminatingCollector.this.numCollected) {
                    throw new EarlyTerminatingCollectorException(EarlyTerminatingCollector.this.numCollected, EarlyTerminatingCollector.this.prevReaderCumulativeSize + (doc + 1));
                }
            }
        };
    }
}

