/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Converter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Expression;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Group;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Label;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Repeater;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.UnionException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.InputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.OutputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Style;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

class CompositeListUnion
implements Repeater {
    private final LabelMap elements;
    private final Expression path;
    private final Context context;
    private final Group group;
    private final Style style;
    private final Type type;

    public CompositeListUnion(Context context, Group group, Expression expression, Type type) {
        this.elements = group.getElements();
        this.style = context.getStyle();
        this.context = context;
        this.group = group;
        this.type = type;
        this.path = expression;
    }

    @Override
    public Object read(InputNode inputNode) {
        Label label = this.group.getText();
        if (label == null) {
            return this.readElement(inputNode);
        }
        return this.readText(inputNode);
    }

    private Object readElement(InputNode inputNode) {
        String string = inputNode.getName();
        String string2 = this.path.getElement(string);
        Label label = (Label)this.elements.get(string2);
        Converter converter = label.getConverter(this.context);
        return converter.read(inputNode);
    }

    private Object readText(InputNode inputNode) {
        Label label = this.group.getText();
        Converter converter = label.getConverter(this.context);
        return converter.read(inputNode);
    }

    @Override
    public Object read(InputNode inputNode, Object object) {
        Object object2 = this.readElement(inputNode, object);
        Label label = this.group.getText();
        if (label != null) {
            return this.readText(inputNode, object);
        }
        return object2;
    }

    private Object readElement(InputNode inputNode, Object object) {
        String string = inputNode.getName();
        String string2 = this.path.getElement(string);
        Label label = (Label)this.elements.get(string2);
        Converter converter = label.getConverter(this.context);
        return converter.read(inputNode, object);
    }

    private Object readText(InputNode inputNode, Object object) {
        Label label = this.group.getText();
        Converter converter = label.getConverter(this.context);
        InputNode inputNode2 = inputNode.getParent();
        return converter.read(inputNode2, object);
    }

    @Override
    public boolean validate(InputNode inputNode) {
        String string = inputNode.getName();
        String string2 = this.path.getElement(string);
        Label label = (Label)this.elements.get(string2);
        Converter converter = label.getConverter(this.context);
        return converter.validate(inputNode);
    }

    @Override
    public void write(OutputNode outputNode, Object object) {
        Collection collection = (Collection)object;
        if (this.group.isInline()) {
            if (!collection.isEmpty()) {
                this.write(outputNode, collection);
            } else if (!outputNode.isCommitted()) {
                outputNode.remove();
            }
        } else {
            this.write(outputNode, collection);
        }
    }

    private void write(OutputNode outputNode, Collection collection) {
        for (Object e : collection) {
            if (e == null) continue;
            Class<?> clazz = e.getClass();
            Label label = this.group.getLabel(clazz);
            if (label == null) {
                throw new UnionException("Entry of %s not declared in %s with annotation %s", clazz, this.type, this.group);
            }
            this.write(outputNode, e, label);
        }
    }

    private void write(OutputNode outputNode, Object object, Label label) {
        Converter converter = label.getConverter(this.context);
        Set<Object> set = Collections.singleton(object);
        if (!label.isInline()) {
            String string = label.getName();
            String string2 = this.style.getElement(string);
            if (!outputNode.isCommitted()) {
                outputNode.setName(string2);
            }
        }
        converter.write(outputNode, set);
    }
}

