/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.FutureArrays;

public class PointsStackTracker {
    private final int numDims;
    private final int bytesPerDim;
    public final List<Cell> stack = new ArrayList<Cell>();

    public PointsStackTracker(int numDims, int bytesPerDim) {
        this.numDims = numDims;
        this.bytesPerDim = bytesPerDim;
    }

    public void onCompare(byte[] minPackedValue, byte[] maxPackedValue) {
        Cell cell = new Cell(minPackedValue, maxPackedValue);
        while (this.stack.size() > 0 && !this.stack.get(this.stack.size() - 1).contains(cell)) {
            this.stack.remove(this.stack.size() - 1);
        }
        this.stack.add(cell);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public class Cell {
        public final byte[] minPackedValue;
        public final byte[] maxPackedValue;

        public Cell(byte[] minPackedValue, byte[] maxPackedValue) {
            this.minPackedValue = (byte[])minPackedValue.clone();
            this.maxPackedValue = (byte[])maxPackedValue.clone();
        }

        public boolean contains(Cell other) {
            for (int dim = 0; dim < PointsStackTracker.this.numDims; ++dim) {
                int offset = dim * PointsStackTracker.this.bytesPerDim;
                if (FutureArrays.compareUnsigned((byte[])other.minPackedValue, (int)offset, (int)(offset + PointsStackTracker.this.bytesPerDim), (byte[])this.minPackedValue, (int)offset, (int)(offset + PointsStackTracker.this.bytesPerDim)) < 0) {
                    return false;
                }
                if (FutureArrays.compareUnsigned((byte[])other.maxPackedValue, (int)offset, (int)(offset + PointsStackTracker.this.bytesPerDim), (byte[])this.maxPackedValue, (int)offset, (int)(offset + PointsStackTracker.this.bytesPerDim)) <= 0) continue;
                return false;
            }
            return true;
        }
    }
}

