/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.util.IOUtils;

public final class CharacterDefinition
extends org.apache.lucene.analysis.morph.CharacterDefinition {
    public static final int CLASS_COUNT = CharacterClass.values().length;
    public static final byte NGRAM = (byte)CharacterClass.NGRAM.ordinal();
    public static final byte DEFAULT = (byte)CharacterClass.DEFAULT.ordinal();
    public static final byte SPACE = (byte)CharacterClass.SPACE.ordinal();
    public static final byte SYMBOL = (byte)CharacterClass.SYMBOL.ordinal();
    public static final byte NUMERIC = (byte)CharacterClass.NUMERIC.ordinal();
    public static final byte ALPHA = (byte)CharacterClass.ALPHA.ordinal();
    public static final byte CYRILLIC = (byte)CharacterClass.CYRILLIC.ordinal();
    public static final byte GREEK = (byte)CharacterClass.GREEK.ordinal();
    public static final byte HIRAGANA = (byte)CharacterClass.HIRAGANA.ordinal();
    public static final byte KATAKANA = (byte)CharacterClass.KATAKANA.ordinal();
    public static final byte KANJI = (byte)CharacterClass.KANJI.ordinal();
    public static final byte HANGUL = (byte)CharacterClass.HANGUL.ordinal();
    public static final byte HANJA = (byte)CharacterClass.HANJA.ordinal();
    public static final byte HANJANUMERIC = (byte)CharacterClass.HANJANUMERIC.ordinal();

    private CharacterDefinition() throws IOException {
        super(CharacterDefinition::getClassResource, "ko_cd", 1, CLASS_COUNT);
    }

    private static InputStream getClassResource() throws IOException {
        String resourcePath = CharacterDefinition.class.getSimpleName() + ".dat";
        return (InputStream)IOUtils.requireResourceNonNull((Object)CharacterDefinition.class.getResourceAsStream(resourcePath), (String)resourcePath);
    }

    public boolean isHanja(char c) {
        byte characterClass = this.getCharacterClass(c);
        return characterClass == HANJA || characterClass == HANJANUMERIC;
    }

    public boolean isHangul(char c) {
        return this.getCharacterClass(c) == HANGUL;
    }

    public boolean hasCoda(char ch) {
        return (ch - 44032) % 28 != 0;
    }

    public static byte lookupCharacterClass(String characterClassName) {
        return (byte)CharacterClass.valueOf(characterClassName).ordinal();
    }

    public static CharacterDefinition getInstance() {
        return SingletonHolder.INSTANCE;
    }

    static enum CharacterClass {
        NGRAM,
        DEFAULT,
        SPACE,
        SYMBOL,
        NUMERIC,
        ALPHA,
        CYRILLIC,
        GREEK,
        HIRAGANA,
        KATAKANA,
        KANJI,
        HANGUL,
        HANJA,
        HANJANUMERIC;

    }

    private static class SingletonHolder {
        static final CharacterDefinition INSTANCE;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = new CharacterDefinition();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load CharacterDefinition.", ioe);
            }
        }
    }
}

